/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class PublishSubscribeCommandsTest
extends JedisCommandTestBase {
    private void publishOne(String channel, String message) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Jedis j = PublishSubscribeCommandsTest.this.createJedis();
                    j.publish(channel, message);
                    j.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    @Test
    public void subscribe() throws InterruptedException {
        this.jedis.subscribe(new JedisPubSub(){

            @Override
            public void onMessage(String channel, String message) {
                PublishSubscribeCommandsTest.assertEquals((Object)"foo", (Object)channel);
                PublishSubscribeCommandsTest.assertEquals((Object)"exit", (Object)message);
                this.unsubscribe();
            }

            @Override
            public void onSubscribe(String channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertEquals((Object)"foo", (Object)channel);
                PublishSubscribeCommandsTest.assertEquals((long)1L, (long)subscribedChannels);
                PublishSubscribeCommandsTest.this.publishOne("foo", "exit");
            }

            @Override
            public void onUnsubscribe(String channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertEquals((Object)"foo", (Object)channel);
                PublishSubscribeCommandsTest.assertEquals((long)0L, (long)subscribedChannels);
            }
        }, "foo");
    }

    @Test
    public void pubSubChannels() {
        List<String> expectedActiveChannels = Arrays.asList("testchan1", "testchan2", "testchan3");
        this.jedis.subscribe(new JedisPubSub(){
            private int count = 0;

            @Override
            public void onSubscribe(String channel, int subscribedChannels) {
                ++this.count;
                if (this.count == 3) {
                    Jedis otherJedis = PublishSubscribeCommandsTest.this.createJedis();
                    List<String> activeChannels = otherJedis.pubsubChannels("test*");
                    PublishSubscribeCommandsTest.assertTrue((boolean)expectedActiveChannels.containsAll(activeChannels));
                    this.unsubscribe();
                }
            }
        }, "testchan1", "testchan2", "testchan3");
    }

    @Test
    public void pubSubNumPat() {
        this.jedis.psubscribe(new JedisPubSub(){
            private int count = 0;

            @Override
            public void onPSubscribe(String pattern, int subscribedChannels) {
                ++this.count;
                if (this.count == 3) {
                    Jedis otherJedis = PublishSubscribeCommandsTest.this.createJedis();
                    Long numPatterns = otherJedis.pubsubNumPat();
                    PublishSubscribeCommandsTest.assertEquals((Object)new Long(2L), (Object)numPatterns);
                    this.punsubscribe();
                }
            }
        }, "test*", "test*", "chan*");
    }

    @Test
    public void pubSubNumSub() {
        HashMap<String, String> expectedNumSub = new HashMap<String, String>();
        expectedNumSub.put("testchannel2", "1");
        expectedNumSub.put("testchannel1", "1");
        this.jedis.subscribe(new JedisPubSub(){
            private int count = 0;

            @Override
            public void onSubscribe(String channel, int subscribedChannels) {
                ++this.count;
                if (this.count == 2) {
                    Jedis otherJedis = PublishSubscribeCommandsTest.this.createJedis();
                    Map<String, String> numSub = otherJedis.pubsubNumSub("testchannel1", "testchannel2");
                    PublishSubscribeCommandsTest.assertEquals((Object)expectedNumSub, numSub);
                    this.unsubscribe();
                }
            }
        }, "testchannel1", "testchannel2");
    }

    @Test
    public void subscribeMany() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.subscribe(new JedisPubSub(){

            @Override
            public void onMessage(String channel, String message) {
                this.unsubscribe(channel);
            }

            @Override
            public void onSubscribe(String channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(channel, "exit");
            }
        }, "foo", "bar");
    }

    @Test
    public void psubscribe() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.psubscribe(new JedisPubSub(){

            @Override
            public void onPSubscribe(String pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertEquals((Object)"foo.*", (Object)pattern);
                PublishSubscribeCommandsTest.assertEquals((long)1L, (long)subscribedChannels);
                PublishSubscribeCommandsTest.this.publishOne("foo.bar", "exit");
            }

            @Override
            public void onPUnsubscribe(String pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertEquals((Object)"foo.*", (Object)pattern);
                PublishSubscribeCommandsTest.assertEquals((long)0L, (long)subscribedChannels);
            }

            @Override
            public void onPMessage(String pattern, String channel, String message) {
                PublishSubscribeCommandsTest.assertEquals((Object)"foo.*", (Object)pattern);
                PublishSubscribeCommandsTest.assertEquals((Object)"foo.bar", (Object)channel);
                PublishSubscribeCommandsTest.assertEquals((Object)"exit", (Object)message);
                this.punsubscribe();
            }
        }, "foo.*");
    }

    @Test
    public void psubscribeMany() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.psubscribe(new JedisPubSub(){

            @Override
            public void onPSubscribe(String pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(pattern.replace("*", "123"), "exit");
            }

            @Override
            public void onPMessage(String pattern, String channel, String message) {
                this.punsubscribe(pattern);
            }
        }, "foo.*", "bar.*");
    }

    @Test
    public void subscribeLazily() throws UnknownHostException, IOException, InterruptedException {
        JedisPubSub pubsub = new JedisPubSub(){

            @Override
            public void onMessage(String channel, String message) {
                this.unsubscribe(channel);
            }

            @Override
            public void onSubscribe(String channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(channel, "exit");
                if (!channel.equals("bar")) {
                    this.subscribe("bar");
                    this.psubscribe("bar.*");
                }
            }

            @Override
            public void onPSubscribe(String pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(pattern.replace("*", "123"), "exit");
            }

            @Override
            public void onPMessage(String pattern, String channel, String message) {
                this.punsubscribe(pattern);
            }
        };
        this.jedis.subscribe(pubsub, "foo");
    }

    @Test
    public void binarySubscribe() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.subscribe(new BinaryJedisPubSub(){

            @Override
            public void onMessage(byte[] channel, byte[] message) {
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo"), channel));
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("exit"), message));
                this.unsubscribe();
            }

            @Override
            public void onSubscribe(byte[] channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo"), channel));
                PublishSubscribeCommandsTest.assertEquals((long)1L, (long)subscribedChannels);
                PublishSubscribeCommandsTest.this.publishOne(SafeEncoder.encode(channel), "exit");
            }

            @Override
            public void onUnsubscribe(byte[] channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo"), channel));
                PublishSubscribeCommandsTest.assertEquals((long)0L, (long)subscribedChannels);
            }
        }, new byte[][]{SafeEncoder.encode("foo")});
    }

    @Test
    public void binarySubscribeMany() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.subscribe(new BinaryJedisPubSub(){

            @Override
            public void onMessage(byte[] channel, byte[] message) {
                this.unsubscribe(new byte[][]{channel});
            }

            @Override
            public void onSubscribe(byte[] channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(SafeEncoder.encode(channel), "exit");
            }
        }, SafeEncoder.encode("foo"), SafeEncoder.encode("bar"));
    }

    @Test
    public void binaryPsubscribe() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.psubscribe(new BinaryJedisPubSub(){

            @Override
            public void onPSubscribe(byte[] pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo.*"), pattern));
                PublishSubscribeCommandsTest.assertEquals((long)1L, (long)subscribedChannels);
                PublishSubscribeCommandsTest.this.publishOne(SafeEncoder.encode(pattern).replace("*", "bar"), "exit");
            }

            @Override
            public void onPUnsubscribe(byte[] pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo.*"), pattern));
                PublishSubscribeCommandsTest.assertEquals((long)0L, (long)subscribedChannels);
            }

            @Override
            public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo.*"), pattern));
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("foo.bar"), channel));
                PublishSubscribeCommandsTest.assertTrue((boolean)Arrays.equals(SafeEncoder.encode("exit"), message));
                this.punsubscribe();
            }
        }, new byte[][]{SafeEncoder.encode("foo.*")});
    }

    @Test
    public void binaryPsubscribeMany() throws UnknownHostException, IOException, InterruptedException {
        this.jedis.psubscribe(new BinaryJedisPubSub(){

            @Override
            public void onPSubscribe(byte[] pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(SafeEncoder.encode(pattern).replace("*", "123"), "exit");
            }

            @Override
            public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
                this.punsubscribe(new byte[][]{pattern});
            }
        }, SafeEncoder.encode("foo.*"), SafeEncoder.encode("bar.*"));
    }

    @Test
    public void binarySubscribeLazily() throws UnknownHostException, IOException, InterruptedException {
        BinaryJedisPubSub pubsub = new BinaryJedisPubSub(){

            @Override
            public void onMessage(byte[] channel, byte[] message) {
                this.unsubscribe(new byte[][]{channel});
            }

            @Override
            public void onSubscribe(byte[] channel, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(SafeEncoder.encode(channel), "exit");
                if (!SafeEncoder.encode(channel).equals("bar")) {
                    this.subscribe(new byte[][]{SafeEncoder.encode("bar")});
                    this.psubscribe(new byte[][]{SafeEncoder.encode("bar.*")});
                }
            }

            @Override
            public void onPSubscribe(byte[] pattern, int subscribedChannels) {
                PublishSubscribeCommandsTest.this.publishOne(SafeEncoder.encode(pattern).replace("*", "123"), "exit");
            }

            @Override
            public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
                this.punsubscribe(new byte[][]{pattern});
            }
        };
        this.jedis.subscribe(pubsub, new byte[][]{SafeEncoder.encode("foo")});
    }

    @Test(expected=JedisConnectionException.class)
    public void unsubscribeWhenNotSusbscribed() throws InterruptedException {
        JedisPubSub pubsub = new JedisPubSub(){};
        pubsub.unsubscribe();
    }

    @Test(expected=JedisConnectionException.class)
    public void handleClientOutputBufferLimitForSubscribeTooSlow() throws InterruptedException {
        Jedis j = this.createJedis();
        AtomicBoolean exit = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String veryLargeString = PublishSubscribeCommandsTest.this.makeLargeString(0xA00000);
                    int i = 0;
                    while (i < 10 && !exit.get()) {
                        j.publish("foo", veryLargeString);
                        ++i;
                    }
                    j.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
        try {
            this.jedis.subscribe(new JedisPubSub(){

                @Override
                public void onMessage(String channel, String message) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        try {
                            t.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PublishSubscribeCommandsTest.fail((String)e.getMessage());
                    }
                }
            }, "foo");
        }
        finally {
            exit.set(true);
            if (t.isAlive()) {
                t.join();
            }
        }
    }

    private String makeLargeString(int size) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < size) {
            sb.append((char)(97 + i % 26));
            ++i;
        }
        return sb.toString();
    }

    static /* synthetic */ void access$0(PublishSubscribeCommandsTest publishSubscribeCommandsTest, String string, String string2) {
        publishSubscribeCommandsTest.publishOne(string, string2);
    }

    static /* synthetic */ String access$1(PublishSubscribeCommandsTest publishSubscribeCommandsTest, int n) {
        return publishSubscribeCommandsTest.makeLargeString(n);
    }
}

