/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import org.junit.Test;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class ObjectCommandsTest
extends JedisCommandTestBase {
    private String key = "mylist";
    private byte[] binaryKey = SafeEncoder.encode(this.key);

    @Test
    public void objectRefcount() {
        this.jedis.lpush(this.key, "hello world");
        Long refcount = this.jedis.objectRefcount(this.key);
        ObjectCommandsTest.assertEquals((Object)new Long(1L), (Object)refcount);
        refcount = this.jedis.objectRefcount(this.binaryKey);
        ObjectCommandsTest.assertEquals((Object)new Long(1L), (Object)refcount);
    }

    @Test
    public void objectEncoding() {
        this.jedis.lpush(this.key, "hello world");
        String encoding = this.jedis.objectEncoding(this.key);
        ObjectCommandsTest.assertEquals((Object)"quicklist", (Object)encoding);
        encoding = SafeEncoder.encode(this.jedis.objectEncoding(this.binaryKey));
        ObjectCommandsTest.assertEquals((Object)"quicklist", (Object)encoding);
    }

    @Test
    public void objectIdletime() throws InterruptedException {
        this.jedis.lpush(this.key, "hello world");
        Long time = this.jedis.objectIdletime(this.key);
        ObjectCommandsTest.assertEquals((Object)new Long(0L), (Object)time);
        time = this.jedis.objectIdletime(this.binaryKey);
        ObjectCommandsTest.assertEquals((Object)new Long(0L), (Object)time);
    }
}

