/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class ListCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] bcar = new byte[]{9, 10, 11, 12};
    final byte[] bA = new byte[]{10};
    final byte[] bB = new byte[]{11};
    final byte[] bC = new byte[]{12};
    final byte[] b1 = new byte[]{1};
    final byte[] b2 = new byte[]{2};
    final byte[] b3 = new byte[]{3};
    final byte[] bhello = new byte[]{4, 2};
    final byte[] bx = new byte[]{2, 4};
    final byte[] bdst = new byte[]{17, 18, 19, 20};

    @Test
    public void rpush() {
        long size = this.jedis.rpush("foo", "bar");
        ListCommandsTest.assertEquals((long)1L, (long)size);
        size = this.jedis.rpush("foo", "foo");
        ListCommandsTest.assertEquals((long)2L, (long)size);
        size = this.jedis.rpush("foo", "bar", "foo");
        ListCommandsTest.assertEquals((long)4L, (long)size);
        long bsize = this.jedis.rpush(this.bfoo, new byte[][]{this.bbar});
        ListCommandsTest.assertEquals((long)1L, (long)bsize);
        bsize = this.jedis.rpush(this.bfoo, new byte[][]{this.bfoo});
        ListCommandsTest.assertEquals((long)2L, (long)bsize);
        bsize = this.jedis.rpush(this.bfoo, this.bbar, this.bfoo);
        ListCommandsTest.assertEquals((long)4L, (long)bsize);
    }

    @Test
    public void lpush() {
        long size = this.jedis.lpush("foo", "bar");
        ListCommandsTest.assertEquals((long)1L, (long)size);
        size = this.jedis.lpush("foo", "foo");
        ListCommandsTest.assertEquals((long)2L, (long)size);
        size = this.jedis.lpush("foo", "bar", "foo");
        ListCommandsTest.assertEquals((long)4L, (long)size);
        long bsize = this.jedis.lpush(this.bfoo, new byte[][]{this.bbar});
        ListCommandsTest.assertEquals((long)1L, (long)bsize);
        bsize = this.jedis.lpush(this.bfoo, new byte[][]{this.bfoo});
        ListCommandsTest.assertEquals((long)2L, (long)bsize);
        bsize = this.jedis.lpush(this.bfoo, this.bbar, this.bfoo);
        ListCommandsTest.assertEquals((long)4L, (long)bsize);
    }

    @Test
    public void llen() {
        ListCommandsTest.assertEquals((long)0L, (long)this.jedis.llen("foo").intValue());
        this.jedis.lpush("foo", "bar");
        this.jedis.lpush("foo", "car");
        ListCommandsTest.assertEquals((long)2L, (long)this.jedis.llen("foo").intValue());
        ListCommandsTest.assertEquals((long)0L, (long)this.jedis.llen(this.bfoo).intValue());
        this.jedis.lpush(this.bfoo, new byte[][]{this.bbar});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bcar});
        ListCommandsTest.assertEquals((long)2L, (long)this.jedis.llen(this.bfoo).intValue());
    }

    @Test
    public void llenNotOnList() {
        try {
            this.jedis.set("foo", "bar");
            this.jedis.llen("foo");
            ListCommandsTest.fail((String)"JedisDataException expected");
        }
        catch (JedisDataException jedisDataException) {
            // empty catch block
        }
        try {
            this.jedis.set(this.bfoo, this.bbar);
            this.jedis.llen(this.bfoo);
            ListCommandsTest.fail((String)"JedisDataException expected");
        }
        catch (JedisDataException jedisDataException) {
            // empty catch block
        }
    }

    @Test
    public void lrange() {
        this.jedis.rpush("foo", "a");
        this.jedis.rpush("foo", "b");
        this.jedis.rpush("foo", "c");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        List<String> range = this.jedis.lrange("foo", 0L, 2L);
        ListCommandsTest.assertEquals(expected, range);
        range = this.jedis.lrange("foo", 0L, 20L);
        ListCommandsTest.assertEquals(expected, range);
        expected = new ArrayList();
        expected.add("b");
        expected.add("c");
        range = this.jedis.lrange("foo", 1L, 2L);
        ListCommandsTest.assertEquals(expected, range);
        expected = new ArrayList();
        range = this.jedis.lrange("foo", 2L, 1L);
        ListCommandsTest.assertEquals(expected, range);
        this.jedis.rpush(this.bfoo, new byte[][]{this.bA});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bB});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bC});
        ArrayList<Object> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bA);
        bexpected.add(this.bB);
        bexpected.add(this.bC);
        List<byte[]> brange = this.jedis.lrange(this.bfoo, 0L, 2L);
        this.assertEquals(bexpected, brange);
        brange = this.jedis.lrange(this.bfoo, 0L, 20L);
        this.assertEquals(bexpected, brange);
        bexpected = new ArrayList();
        bexpected.add(this.bB);
        bexpected.add((byte[])((Object)this.bC));
        brange = this.jedis.lrange(this.bfoo, 1L, 2L);
        this.assertEquals(bexpected, brange);
        bexpected = new ArrayList();
        brange = this.jedis.lrange(this.bfoo, 2L, 1L);
        this.assertEquals(bexpected, brange);
    }

    @Test
    public void ltrim() {
        this.jedis.lpush("foo", "1");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "3");
        String status = this.jedis.ltrim("foo", 0L, 1L);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("3");
        expected.add("2");
        ListCommandsTest.assertEquals((Object)"OK", (Object)status);
        ListCommandsTest.assertEquals((long)2L, (long)this.jedis.llen("foo").intValue());
        ListCommandsTest.assertEquals(expected, this.jedis.lrange("foo", 0L, 100L));
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b3});
        String bstatus = this.jedis.ltrim(this.bfoo, 0L, 1L);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b3);
        bexpected.add(this.b2);
        ListCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        ListCommandsTest.assertEquals((long)2L, (long)this.jedis.llen(this.bfoo).intValue());
        this.assertEquals(bexpected, this.jedis.lrange(this.bfoo, 0L, 100L));
    }

    @Test
    public void lindex() {
        this.jedis.lpush("foo", "1");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "3");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("3");
        expected.add("bar");
        expected.add("1");
        String status = this.jedis.lset("foo", 1L, "bar");
        ListCommandsTest.assertEquals((Object)"OK", (Object)status);
        ListCommandsTest.assertEquals(expected, this.jedis.lrange("foo", 0L, 100L));
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b3});
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b3);
        bexpected.add(this.bbar);
        bexpected.add(this.b1);
        String bstatus = this.jedis.lset(this.bfoo, 1L, this.bbar);
        ListCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        this.assertEquals(bexpected, this.jedis.lrange(this.bfoo, 0L, 100L));
    }

    @Test
    public void lset() {
        this.jedis.lpush("foo", "1");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "3");
        ListCommandsTest.assertEquals((Object)"3", (Object)this.jedis.lindex("foo", 0L));
        ListCommandsTest.assertEquals(null, (Object)this.jedis.lindex("foo", 100L));
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b3});
        ListCommandsTest.assertArrayEquals((byte[])this.b3, (byte[])this.jedis.lindex(this.bfoo, 0L));
        ListCommandsTest.assertEquals(null, (Object)this.jedis.lindex(this.bfoo, 100L));
    }

    @Test
    public void lrem() {
        this.jedis.lpush("foo", "hello");
        this.jedis.lpush("foo", "hello");
        this.jedis.lpush("foo", "x");
        this.jedis.lpush("foo", "hello");
        this.jedis.lpush("foo", "c");
        this.jedis.lpush("foo", "b");
        this.jedis.lpush("foo", "a");
        long count = this.jedis.lrem("foo", -2L, "hello");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        expected.add("hello");
        expected.add("x");
        ListCommandsTest.assertEquals((long)2L, (long)count);
        ListCommandsTest.assertEquals(expected, this.jedis.lrange("foo", 0L, 1000L));
        ListCommandsTest.assertEquals((long)0L, (long)this.jedis.lrem("bar", 100L, "foo").intValue());
        this.jedis.lpush(this.bfoo, new byte[][]{this.bhello});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bhello});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bx});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bhello});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bC});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bB});
        this.jedis.lpush(this.bfoo, new byte[][]{this.bA});
        long bcount = this.jedis.lrem(this.bfoo, -2L, this.bhello);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bA);
        bexpected.add(this.bB);
        bexpected.add(this.bC);
        bexpected.add(this.bhello);
        bexpected.add(this.bx);
        ListCommandsTest.assertEquals((long)2L, (long)bcount);
        this.assertEquals(bexpected, this.jedis.lrange(this.bfoo, 0L, 1000L));
        ListCommandsTest.assertEquals((long)0L, (long)this.jedis.lrem(this.bbar, 100L, this.bfoo).intValue());
    }

    @Test
    public void lpop() {
        this.jedis.rpush("foo", "a");
        this.jedis.rpush("foo", "b");
        this.jedis.rpush("foo", "c");
        String element = this.jedis.lpop("foo");
        ListCommandsTest.assertEquals((Object)"a", (Object)element);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("b");
        expected.add("c");
        ListCommandsTest.assertEquals(expected, this.jedis.lrange("foo", 0L, 1000L));
        this.jedis.lpop("foo");
        this.jedis.lpop("foo");
        element = this.jedis.lpop("foo");
        ListCommandsTest.assertEquals(null, (Object)element);
        this.jedis.rpush(this.bfoo, new byte[][]{this.bA});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bB});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bC});
        byte[] belement = this.jedis.lpop(this.bfoo);
        ListCommandsTest.assertArrayEquals((byte[])this.bA, (byte[])belement);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bB);
        bexpected.add(this.bC);
        this.assertEquals(bexpected, this.jedis.lrange(this.bfoo, 0L, 1000L));
        this.jedis.lpop(this.bfoo);
        this.jedis.lpop(this.bfoo);
        belement = this.jedis.lpop(this.bfoo);
        ListCommandsTest.assertEquals(null, (Object)belement);
    }

    @Test
    public void rpop() {
        this.jedis.rpush("foo", "a");
        this.jedis.rpush("foo", "b");
        this.jedis.rpush("foo", "c");
        String element = this.jedis.rpop("foo");
        ListCommandsTest.assertEquals((Object)"c", (Object)element);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("a");
        expected.add("b");
        ListCommandsTest.assertEquals(expected, this.jedis.lrange("foo", 0L, 1000L));
        this.jedis.rpop("foo");
        this.jedis.rpop("foo");
        element = this.jedis.rpop("foo");
        ListCommandsTest.assertEquals(null, (Object)element);
        this.jedis.rpush(this.bfoo, new byte[][]{this.bA});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bB});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bC});
        byte[] belement = this.jedis.rpop(this.bfoo);
        ListCommandsTest.assertArrayEquals((byte[])this.bC, (byte[])belement);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bA);
        bexpected.add(this.bB);
        this.assertEquals(bexpected, this.jedis.lrange(this.bfoo, 0L, 1000L));
        this.jedis.rpop(this.bfoo);
        this.jedis.rpop(this.bfoo);
        belement = this.jedis.rpop(this.bfoo);
        ListCommandsTest.assertEquals(null, (Object)belement);
    }

    @Test
    public void rpoplpush() {
        this.jedis.rpush("foo", "a");
        this.jedis.rpush("foo", "b");
        this.jedis.rpush("foo", "c");
        this.jedis.rpush("dst", "foo");
        this.jedis.rpush("dst", "bar");
        String element = this.jedis.rpoplpush("foo", "dst");
        ListCommandsTest.assertEquals((Object)"c", (Object)element);
        ArrayList<String> srcExpected = new ArrayList<String>();
        srcExpected.add("a");
        srcExpected.add("b");
        ArrayList<String> dstExpected = new ArrayList<String>();
        dstExpected.add("c");
        dstExpected.add("foo");
        dstExpected.add("bar");
        ListCommandsTest.assertEquals(srcExpected, this.jedis.lrange("foo", 0L, 1000L));
        ListCommandsTest.assertEquals(dstExpected, this.jedis.lrange("dst", 0L, 1000L));
        this.jedis.rpush(this.bfoo, new byte[][]{this.bA});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bB});
        this.jedis.rpush(this.bfoo, new byte[][]{this.bC});
        this.jedis.rpush(this.bdst, new byte[][]{this.bfoo});
        this.jedis.rpush(this.bdst, new byte[][]{this.bbar});
        byte[] belement = this.jedis.rpoplpush(this.bfoo, this.bdst);
        ListCommandsTest.assertArrayEquals((byte[])this.bC, (byte[])belement);
        ArrayList<byte[]> bsrcExpected = new ArrayList<byte[]>();
        bsrcExpected.add(this.bA);
        bsrcExpected.add(this.bB);
        ArrayList<byte[]> bdstExpected = new ArrayList<byte[]>();
        bdstExpected.add(this.bC);
        bdstExpected.add(this.bfoo);
        bdstExpected.add(this.bbar);
        this.assertEquals(bsrcExpected, this.jedis.lrange(this.bfoo, 0L, 1000L));
        this.assertEquals(bdstExpected, this.jedis.lrange(this.bdst, 0L, 1000L));
    }

    @Test
    public void blpop() throws InterruptedException {
        List<String> result = this.jedis.blpop(1, "foo");
        ListCommandsTest.assertNull(result);
        this.jedis.lpush("foo", "bar");
        result = this.jedis.blpop(1, "foo");
        ListCommandsTest.assertNotNull(result);
        ListCommandsTest.assertEquals((long)2L, (long)result.size());
        ListCommandsTest.assertEquals((Object)"foo", (Object)result.get(0));
        ListCommandsTest.assertEquals((Object)"bar", (Object)result.get(1));
        this.jedis.lpush(this.bfoo, new byte[][]{this.bbar});
        List<byte[]> bresult = this.jedis.blpop(1, (byte[][])new byte[][]{this.bfoo});
        ListCommandsTest.assertNotNull(bresult);
        ListCommandsTest.assertEquals((long)2L, (long)bresult.size());
        ListCommandsTest.assertArrayEquals((byte[])this.bfoo, (byte[])bresult.get(0));
        ListCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])bresult.get(1));
    }

    @Test
    public void brpop() throws InterruptedException {
        List<String> result = this.jedis.brpop(1, "foo");
        ListCommandsTest.assertNull(result);
        this.jedis.lpush("foo", "bar");
        result = this.jedis.brpop(1, "foo");
        ListCommandsTest.assertNotNull(result);
        ListCommandsTest.assertEquals((long)2L, (long)result.size());
        ListCommandsTest.assertEquals((Object)"foo", (Object)result.get(0));
        ListCommandsTest.assertEquals((Object)"bar", (Object)result.get(1));
        this.jedis.lpush(this.bfoo, new byte[][]{this.bbar});
        List<byte[]> bresult = this.jedis.brpop(1, (byte[][])new byte[][]{this.bfoo});
        ListCommandsTest.assertNotNull(bresult);
        ListCommandsTest.assertEquals((long)2L, (long)bresult.size());
        ListCommandsTest.assertArrayEquals((byte[])this.bfoo, (byte[])bresult.get(0));
        ListCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])bresult.get(1));
    }

    @Test
    public void lpushx() {
        long status = this.jedis.lpushx("foo", "bar");
        ListCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.lpush("foo", "a");
        status = this.jedis.lpushx("foo", "b");
        ListCommandsTest.assertEquals((long)2L, (long)status);
        long bstatus = this.jedis.lpushx(this.bfoo, new byte[][]{this.bbar});
        ListCommandsTest.assertEquals((long)0L, (long)bstatus);
        this.jedis.lpush(this.bfoo, new byte[][]{this.bA});
        bstatus = this.jedis.lpushx(this.bfoo, new byte[][]{this.bB});
        ListCommandsTest.assertEquals((long)2L, (long)bstatus);
    }

    @Test
    public void rpushx() {
        long status = this.jedis.rpushx("foo", "bar");
        ListCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.lpush("foo", "a");
        status = this.jedis.rpushx("foo", "b");
        ListCommandsTest.assertEquals((long)2L, (long)status);
        long bstatus = this.jedis.rpushx(this.bfoo, new byte[][]{this.bbar});
        ListCommandsTest.assertEquals((long)0L, (long)bstatus);
        this.jedis.lpush(this.bfoo, new byte[][]{this.bA});
        bstatus = this.jedis.rpushx(this.bfoo, new byte[][]{this.bB});
        ListCommandsTest.assertEquals((long)2L, (long)bstatus);
    }

    @Test
    public void linsert() {
        long status = this.jedis.linsert("foo", BinaryClient.LIST_POSITION.BEFORE, "bar", "car");
        ListCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.lpush("foo", "a");
        status = this.jedis.linsert("foo", BinaryClient.LIST_POSITION.AFTER, "a", "b");
        ListCommandsTest.assertEquals((long)2L, (long)status);
        List<String> actual = this.jedis.lrange("foo", 0L, 100L);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("a");
        expected.add("b");
        ListCommandsTest.assertEquals(expected, actual);
        status = this.jedis.linsert("foo", BinaryClient.LIST_POSITION.BEFORE, "bar", "car");
        ListCommandsTest.assertEquals((long)-1L, (long)status);
        long bstatus = this.jedis.linsert(this.bfoo, BinaryClient.LIST_POSITION.BEFORE, this.bbar, this.bcar);
        ListCommandsTest.assertEquals((long)0L, (long)bstatus);
        this.jedis.lpush(this.bfoo, new byte[][]{this.bA});
        bstatus = this.jedis.linsert(this.bfoo, BinaryClient.LIST_POSITION.AFTER, this.bA, this.bB);
        ListCommandsTest.assertEquals((long)2L, (long)bstatus);
        List<byte[]> bactual = this.jedis.lrange(this.bfoo, 0L, 100L);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bA);
        bexpected.add(this.bB);
        this.assertEquals(bexpected, bactual);
        bstatus = this.jedis.linsert(this.bfoo, BinaryClient.LIST_POSITION.BEFORE, this.bbar, this.bcar);
        ListCommandsTest.assertEquals((long)-1L, (long)bstatus);
    }

    @Test
    public void brpoplpush() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    Jedis j = ListCommandsTest.this.createJedis();
                    j.lpush("foo", "a");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        String element = this.jedis.brpoplpush("foo", "bar", 0);
        ListCommandsTest.assertEquals((Object)"a", (Object)element);
        ListCommandsTest.assertEquals((long)1L, (long)this.jedis.llen("bar"));
        ListCommandsTest.assertEquals((Object)"a", (Object)this.jedis.lrange("bar", 0L, -1L).get(0));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    Jedis j = ListCommandsTest.this.createJedis();
                    j.lpush("foo", "a");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        byte[] brpoplpush = this.jedis.brpoplpush("foo".getBytes(), "bar".getBytes(), 0);
        ListCommandsTest.assertTrue((boolean)Arrays.equals("a".getBytes(), brpoplpush));
        ListCommandsTest.assertEquals((long)1L, (long)this.jedis.llen("bar"));
        ListCommandsTest.assertEquals((Object)"a", (Object)this.jedis.lrange("bar", 0L, -1L).get(0));
    }
}

