/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.ComparisonFailure;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.JedisTestBase;

public abstract class JedisCommandTestBase
extends JedisTestBase {
    protected static HostAndPort hnp = HostAndPortUtil.getRedisServers().get(0);
    protected Jedis jedis;

    @Before
    public void setUp() throws Exception {
        this.jedis = new Jedis(hnp.getHost(), hnp.getPort(), 500);
        this.jedis.connect();
        this.jedis.auth("foobared");
        this.jedis.configSet("timeout", "300");
        this.jedis.flushAll();
    }

    @After
    public void tearDown() {
        this.jedis.disconnect();
    }

    protected Jedis createJedis() {
        Jedis j = new Jedis(hnp.getHost(), hnp.getPort());
        j.connect();
        j.auth("foobared");
        j.flushAll();
        return j;
    }

    @Override
    protected void assertEquals(List<byte[]> expected, List<byte[]> actual) {
        JedisCommandTestBase.assertEquals((long)expected.size(), (long)actual.size());
        int n = 0;
        while (n < expected.size()) {
            JedisCommandTestBase.assertArrayEquals((byte[])expected.get(n), (byte[])actual.get(n));
            ++n;
        }
    }

    @Override
    protected void assertEquals(Set<byte[]> expected, Set<byte[]> actual) {
        JedisCommandTestBase.assertEquals((long)expected.size(), (long)actual.size());
        for (byte[] next : expected) {
            boolean contained = false;
            for (byte[] element : expected) {
                if (!Arrays.equals(next, element)) continue;
                contained = true;
            }
            if (contained) continue;
            throw new ComparisonFailure("element is missing", Arrays.toString(next), actual.toString());
        }
    }

    protected boolean arrayContains(List<byte[]> array, byte[] expected) {
        for (byte[] a : array) {
            try {
                JedisCommandTestBase.assertArrayEquals((byte[])a, (byte[])expected);
                return true;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean setContains(Set<byte[]> set, byte[] expected) {
        for (byte[] a : set) {
            try {
                JedisCommandTestBase.assertArrayEquals((byte[])a, (byte[])expected);
                return true;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        return false;
    }
}

