/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import org.junit.Test;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class HyperLogLogCommandsTest
extends JedisCommandTestBase {
    @Test
    public void pfadd() {
        long status = this.jedis.pfadd("foo", "a");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd("foo", "a");
        HyperLogLogCommandsTest.assertEquals((long)0L, (long)status);
    }

    @Test
    public void pfaddBinary() {
        byte[] bFoo = SafeEncoder.encode("foo");
        byte[] bBar = SafeEncoder.encode("bar");
        byte[] bBar2 = SafeEncoder.encode("bar2");
        long status = this.jedis.pfadd(bFoo, bBar, bBar2);
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd(bFoo, bBar, bBar2);
        HyperLogLogCommandsTest.assertEquals((long)0L, (long)status);
    }

    @Test
    public void pfcount() {
        long status = this.jedis.pfadd("hll", "foo", "bar", "zap");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd("hll", "zap", "zap", "zap");
        HyperLogLogCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.pfadd("hll", "foo", "bar");
        HyperLogLogCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.pfcount("hll");
        HyperLogLogCommandsTest.assertEquals((long)3L, (long)status);
    }

    @Test
    public void pfcounts() {
        long status = this.jedis.pfadd("hll_1", "foo", "bar", "zap");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd("hll_2", "foo", "bar", "zap");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd("hll_3", "foo", "bar", "baz");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfcount("hll_1");
        HyperLogLogCommandsTest.assertEquals((long)3L, (long)status);
        status = this.jedis.pfcount("hll_2");
        HyperLogLogCommandsTest.assertEquals((long)3L, (long)status);
        status = this.jedis.pfcount("hll_3");
        HyperLogLogCommandsTest.assertEquals((long)3L, (long)status);
        status = this.jedis.pfcount("hll_1", "hll_2");
        HyperLogLogCommandsTest.assertEquals((long)3L, (long)status);
        status = this.jedis.pfcount("hll_1", "hll_2", "hll_3");
        HyperLogLogCommandsTest.assertEquals((long)4L, (long)status);
    }

    @Test
    public void pfcountBinary() {
        byte[] bHll = SafeEncoder.encode("hll");
        byte[] bFoo = SafeEncoder.encode("foo");
        byte[] bBar = SafeEncoder.encode("bar");
        byte[] bZap = SafeEncoder.encode("zap");
        long status = this.jedis.pfadd(bHll, bFoo, bBar, bZap);
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd(bHll, bZap, bZap, bZap);
        HyperLogLogCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.pfadd(bHll, bFoo, bBar);
        HyperLogLogCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.pfcount(bHll);
        HyperLogLogCommandsTest.assertEquals((long)3L, (long)status);
    }

    @Test
    public void pfmerge() {
        long status = this.jedis.pfadd("hll1", "foo", "bar", "zap", "a");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd("hll2", "a", "b", "c", "foo");
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        String mergeStatus = this.jedis.pfmerge("hll3", "hll1", "hll2");
        HyperLogLogCommandsTest.assertEquals((Object)"OK", (Object)mergeStatus);
        status = this.jedis.pfcount("hll3");
        HyperLogLogCommandsTest.assertEquals((long)6L, (long)status);
    }

    @Test
    public void pfmergeBinary() {
        byte[] bHll1 = SafeEncoder.encode("hll1");
        byte[] bHll2 = SafeEncoder.encode("hll2");
        byte[] bHll3 = SafeEncoder.encode("hll3");
        byte[] bFoo = SafeEncoder.encode("foo");
        byte[] bBar = SafeEncoder.encode("bar");
        byte[] bZap = SafeEncoder.encode("zap");
        byte[] bA = SafeEncoder.encode("a");
        byte[] bB = SafeEncoder.encode("b");
        byte[] bC = SafeEncoder.encode("c");
        long status = this.jedis.pfadd(bHll1, bFoo, bBar, bZap, bA);
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.pfadd(bHll2, bA, bB, bC, bFoo);
        HyperLogLogCommandsTest.assertEquals((long)1L, (long)status);
        String mergeStatus = this.jedis.pfmerge(bHll3, bHll1, bHll2);
        HyperLogLogCommandsTest.assertEquals((Object)"OK", (Object)mergeStatus);
        status = this.jedis.pfcount("hll3");
        HyperLogLogCommandsTest.assertEquals((long)6L, (long)status);
    }
}

