/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Test;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class HashesCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] bcar = new byte[]{9, 10, 11, 12};
    final byte[] bbar1 = new byte[]{5, 6, 7, 8, 10};
    final byte[] bbar2 = new byte[]{5, 6, 7, 8, 11};
    final byte[] bbar3 = new byte[]{5, 6, 7, 8, 12};
    final byte[] bbarstar = new byte[]{5, 6, 7, 8, 42};

    @Test
    public void hset() {
        long status = this.jedis.hset("foo", "bar", "car");
        HashesCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.hset("foo", "bar", "foo");
        HashesCommandsTest.assertEquals((long)0L, (long)status);
        long bstatus = this.jedis.hset(this.bfoo, this.bbar, this.bcar);
        HashesCommandsTest.assertEquals((long)1L, (long)bstatus);
        bstatus = this.jedis.hset(this.bfoo, this.bbar, this.bfoo);
        HashesCommandsTest.assertEquals((long)0L, (long)bstatus);
    }

    @Test
    public void hget() {
        this.jedis.hset("foo", "bar", "car");
        HashesCommandsTest.assertEquals(null, (Object)this.jedis.hget("bar", "foo"));
        HashesCommandsTest.assertEquals(null, (Object)this.jedis.hget("foo", "car"));
        HashesCommandsTest.assertEquals((Object)"car", (Object)this.jedis.hget("foo", "bar"));
        this.jedis.hset(this.bfoo, this.bbar, this.bcar);
        HashesCommandsTest.assertEquals(null, (Object)this.jedis.hget(this.bbar, this.bfoo));
        HashesCommandsTest.assertEquals(null, (Object)this.jedis.hget(this.bfoo, this.bcar));
        HashesCommandsTest.assertArrayEquals((byte[])this.bcar, (byte[])this.jedis.hget(this.bfoo, this.bbar));
    }

    @Test
    public void hsetnx() {
        long status = this.jedis.hsetnx("foo", "bar", "car");
        HashesCommandsTest.assertEquals((long)1L, (long)status);
        HashesCommandsTest.assertEquals((Object)"car", (Object)this.jedis.hget("foo", "bar"));
        status = this.jedis.hsetnx("foo", "bar", "foo");
        HashesCommandsTest.assertEquals((long)0L, (long)status);
        HashesCommandsTest.assertEquals((Object)"car", (Object)this.jedis.hget("foo", "bar"));
        status = this.jedis.hsetnx("foo", "car", "bar");
        HashesCommandsTest.assertEquals((long)1L, (long)status);
        HashesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.hget("foo", "car"));
        long bstatus = this.jedis.hsetnx(this.bfoo, this.bbar, this.bcar);
        HashesCommandsTest.assertEquals((long)1L, (long)bstatus);
        HashesCommandsTest.assertArrayEquals((byte[])this.bcar, (byte[])this.jedis.hget(this.bfoo, this.bbar));
        bstatus = this.jedis.hsetnx(this.bfoo, this.bbar, this.bfoo);
        HashesCommandsTest.assertEquals((long)0L, (long)bstatus);
        HashesCommandsTest.assertArrayEquals((byte[])this.bcar, (byte[])this.jedis.hget(this.bfoo, this.bbar));
        bstatus = this.jedis.hsetnx(this.bfoo, this.bcar, this.bbar);
        HashesCommandsTest.assertEquals((long)1L, (long)bstatus);
        HashesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])this.jedis.hget(this.bfoo, this.bcar));
    }

    @Test
    public void hmset() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        String status = this.jedis.hmset("foo", hash);
        HashesCommandsTest.assertEquals((Object)"OK", (Object)status);
        HashesCommandsTest.assertEquals((Object)"car", (Object)this.jedis.hget("foo", "bar"));
        HashesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.hget("foo", "car"));
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        String bstatus = this.jedis.hmset(this.bfoo, bhash);
        HashesCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        HashesCommandsTest.assertArrayEquals((byte[])this.bcar, (byte[])this.jedis.hget(this.bfoo, this.bbar));
        HashesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])this.jedis.hget(this.bfoo, this.bcar));
    }

    @Test
    public void hmget() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        this.jedis.hmset("foo", hash);
        List<String> values = this.jedis.hmget("foo", "bar", "car", "foo");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("car");
        expected.add("bar");
        expected.add(null);
        HashesCommandsTest.assertEquals(expected, values);
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        List<byte[]> bvalues = this.jedis.hmget(this.bfoo, this.bbar, this.bcar, this.bfoo);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bcar);
        bexpected.add(this.bbar);
        bexpected.add(null);
        this.assertEquals(bexpected, bvalues);
    }

    @Test
    public void hincrBy() {
        long value = this.jedis.hincrBy("foo", "bar", 1L);
        HashesCommandsTest.assertEquals((long)1L, (long)value);
        value = this.jedis.hincrBy("foo", "bar", -1L);
        HashesCommandsTest.assertEquals((long)0L, (long)value);
        value = this.jedis.hincrBy("foo", "bar", -10L);
        HashesCommandsTest.assertEquals((long)-10L, (long)value);
        long bvalue = this.jedis.hincrBy(this.bfoo, this.bbar, 1L);
        HashesCommandsTest.assertEquals((long)1L, (long)bvalue);
        bvalue = this.jedis.hincrBy(this.bfoo, this.bbar, -1L);
        HashesCommandsTest.assertEquals((long)0L, (long)bvalue);
        bvalue = this.jedis.hincrBy(this.bfoo, this.bbar, -10L);
        HashesCommandsTest.assertEquals((long)-10L, (long)bvalue);
    }

    @Test
    public void hincrByFloat() {
        Double value = this.jedis.hincrByFloat("foo", "bar", 1.5);
        HashesCommandsTest.assertEquals((Object)1.5, (Object)value);
        value = this.jedis.hincrByFloat("foo", "bar", -1.5);
        HashesCommandsTest.assertEquals((Object)0.0, (Object)value);
        value = this.jedis.hincrByFloat("foo", "bar", -10.7);
        HashesCommandsTest.assertEquals((long)Double.compare(-10.7, value), (long)0L);
        double bvalue = this.jedis.hincrByFloat(this.bfoo, this.bbar, 1.5);
        HashesCommandsTest.assertEquals((long)Double.compare(1.5, bvalue), (long)0L);
        bvalue = this.jedis.hincrByFloat(this.bfoo, this.bbar, -1.5);
        HashesCommandsTest.assertEquals((long)Double.compare(0.0, bvalue), (long)0L);
        bvalue = this.jedis.hincrByFloat(this.bfoo, this.bbar, -10.7);
        HashesCommandsTest.assertEquals((long)Double.compare(-10.7, value), (long)0L);
    }

    @Test
    public void hexists() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        this.jedis.hmset("foo", hash);
        HashesCommandsTest.assertFalse((boolean)this.jedis.hexists("bar", "foo"));
        HashesCommandsTest.assertFalse((boolean)this.jedis.hexists("foo", "foo"));
        HashesCommandsTest.assertTrue((boolean)this.jedis.hexists("foo", "bar"));
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        HashesCommandsTest.assertFalse((boolean)this.jedis.hexists(this.bbar, this.bfoo));
        HashesCommandsTest.assertFalse((boolean)this.jedis.hexists(this.bfoo, this.bfoo));
        HashesCommandsTest.assertTrue((boolean)this.jedis.hexists(this.bfoo, this.bbar));
    }

    @Test
    public void hdel() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        this.jedis.hmset("foo", hash);
        HashesCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel("bar", "foo").intValue());
        HashesCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel("foo", "foo").intValue());
        HashesCommandsTest.assertEquals((long)1L, (long)this.jedis.hdel("foo", "bar").intValue());
        HashesCommandsTest.assertEquals(null, (Object)this.jedis.hget("foo", "bar"));
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        HashesCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel(this.bbar, new byte[][]{this.bfoo}).intValue());
        HashesCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel(this.bfoo, new byte[][]{this.bfoo}).intValue());
        HashesCommandsTest.assertEquals((long)1L, (long)this.jedis.hdel(this.bfoo, new byte[][]{this.bbar}).intValue());
        HashesCommandsTest.assertEquals(null, (Object)this.jedis.hget(this.bfoo, this.bbar));
    }

    @Test
    public void hlen() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        this.jedis.hmset("foo", hash);
        HashesCommandsTest.assertEquals((long)0L, (long)this.jedis.hlen("bar").intValue());
        HashesCommandsTest.assertEquals((long)2L, (long)this.jedis.hlen("foo").intValue());
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        HashesCommandsTest.assertEquals((long)0L, (long)this.jedis.hlen(this.bbar).intValue());
        HashesCommandsTest.assertEquals((long)2L, (long)this.jedis.hlen(this.bfoo).intValue());
    }

    @Test
    public void hkeys() {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        this.jedis.hmset("foo", hash);
        Set<String> keys = this.jedis.hkeys("foo");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("bar");
        expected.add("car");
        HashesCommandsTest.assertEquals(expected, keys);
        LinkedHashMap<byte[], byte[]> bhash = new LinkedHashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        Set<byte[]> bkeys = this.jedis.hkeys(this.bfoo);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bbar);
        bexpected.add(this.bcar);
        this.assertEquals(bexpected, bkeys);
    }

    @Test
    public void hvals() {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        this.jedis.hmset("foo", hash);
        List<String> vals = this.jedis.hvals("foo");
        HashesCommandsTest.assertEquals((long)2L, (long)vals.size());
        HashesCommandsTest.assertTrue((boolean)vals.contains("bar"));
        HashesCommandsTest.assertTrue((boolean)vals.contains("car"));
        LinkedHashMap<byte[], byte[]> bhash = new LinkedHashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        Collection bvals = this.jedis.hvals(this.bfoo);
        HashesCommandsTest.assertEquals((long)2L, (long)bvals.size());
        HashesCommandsTest.assertTrue((boolean)this.arrayContains((List<byte[]>)bvals, this.bbar));
        HashesCommandsTest.assertTrue((boolean)this.arrayContains((List<byte[]>)bvals, this.bcar));
    }

    @Test
    public void hgetAll() {
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("bar", "car");
        h.put("car", "bar");
        this.jedis.hmset("foo", h);
        Map<String, String> hash = this.jedis.hgetAll("foo");
        HashesCommandsTest.assertEquals((long)2L, (long)hash.size());
        HashesCommandsTest.assertEquals((Object)"car", (Object)hash.get("bar"));
        HashesCommandsTest.assertEquals((Object)"bar", (Object)hash.get("car"));
        HashMap<byte[], byte[]> bh = new HashMap<byte[], byte[]>();
        bh.put(this.bbar, this.bcar);
        bh.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bh);
        Map<byte[], byte[]> bhash = this.jedis.hgetAll(this.bfoo);
        HashesCommandsTest.assertEquals((long)2L, (long)bhash.size());
        HashesCommandsTest.assertArrayEquals((byte[])this.bcar, (byte[])bhash.get(this.bbar));
        HashesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])bhash.get(this.bcar));
    }

    @Test
    public void hgetAllPipeline() {
        HashMap<byte[], byte[]> bh = new HashMap<byte[], byte[]>();
        bh.put(this.bbar, this.bcar);
        bh.put(this.bcar, this.bbar);
        this.jedis.hmset(this.bfoo, bh);
        Pipeline pipeline = this.jedis.pipelined();
        Response<Map<byte[], byte[]>> bhashResponse = pipeline.hgetAll(this.bfoo);
        pipeline.sync();
        Map<byte[], byte[]> bhash = bhashResponse.get();
        HashesCommandsTest.assertEquals((long)2L, (long)bhash.size());
        HashesCommandsTest.assertArrayEquals((byte[])this.bcar, (byte[])bhash.get(this.bbar));
        HashesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])bhash.get(this.bcar));
    }

    @Test
    public void hscan() {
        this.jedis.hset("foo", "b", "b");
        this.jedis.hset("foo", "a", "a");
        ScanResult<Map.Entry<String, String>> result = this.jedis.hscan("foo", ScanParams.SCAN_POINTER_START);
        HashesCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        HashesCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        this.jedis.hset(this.bfoo, this.bbar, this.bcar);
        ScanResult<Map.Entry<byte[], byte[]>> bResult = this.jedis.hscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY);
        HashesCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        HashesCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void hscanMatch() {
        ScanParams params = new ScanParams();
        params.match("a*");
        this.jedis.hset("foo", "b", "b");
        this.jedis.hset("foo", "a", "a");
        this.jedis.hset("foo", "aa", "aa");
        ScanResult<Map.Entry<String, String>> result = this.jedis.hscan("foo", ScanParams.SCAN_POINTER_START, params);
        HashesCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        HashesCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.match(this.bbarstar);
        this.jedis.hset(this.bfoo, this.bbar, this.bcar);
        this.jedis.hset(this.bfoo, this.bbar1, this.bcar);
        this.jedis.hset(this.bfoo, this.bbar2, this.bcar);
        this.jedis.hset(this.bfoo, this.bbar3, this.bcar);
        ScanResult<Map.Entry<byte[], byte[]>> bResult = this.jedis.hscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY, params);
        HashesCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        HashesCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void hscanCount() {
        ScanParams params = new ScanParams();
        params.count(2);
        int i = 0;
        while (i < 10) {
            this.jedis.hset("foo", "a" + i, "a" + i);
            ++i;
        }
        ScanResult<Map.Entry<String, String>> result = this.jedis.hscan("foo", ScanParams.SCAN_POINTER_START, params);
        HashesCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.count(2);
        this.jedis.hset(this.bfoo, this.bbar, this.bcar);
        this.jedis.hset(this.bfoo, this.bbar1, this.bcar);
        this.jedis.hset(this.bfoo, this.bbar2, this.bcar);
        this.jedis.hset(this.bfoo, this.bbar3, this.bcar);
        ScanResult<Map.Entry<byte[], byte[]>> bResult = this.jedis.hscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY, params);
        HashesCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }
}

