/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.HashMap;
import java.util.List;
import org.junit.Test;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class GeoCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bA = new byte[]{10};
    final byte[] bB = new byte[]{11};
    final byte[] bC = new byte[]{12};
    final byte[] bD = new byte[]{13};
    final byte[] bNotexist = new byte[]{15};

    @Test
    public void geoadd() {
        long size = this.jedis.geoadd("foo", 1.0, 2.0, "a");
        GeoCommandsTest.assertEquals((long)1L, (long)size);
        size = this.jedis.geoadd("foo", 2.0, 3.0, "a");
        GeoCommandsTest.assertEquals((long)0L, (long)size);
        HashMap<String, GeoCoordinate> coordinateMap = new HashMap<String, GeoCoordinate>();
        coordinateMap.put("a", new GeoCoordinate(3.0, 4.0));
        coordinateMap.put("b", new GeoCoordinate(2.0, 3.0));
        coordinateMap.put("c", new GeoCoordinate(3.314, 2.3241));
        size = this.jedis.geoadd("foo", coordinateMap);
        GeoCommandsTest.assertEquals((long)2L, (long)size);
        size = this.jedis.geoadd(this.bfoo, 1.0, 2.0, this.bA);
        GeoCommandsTest.assertEquals((long)1L, (long)size);
        size = this.jedis.geoadd(this.bfoo, 2.0, 3.0, this.bA);
        GeoCommandsTest.assertEquals((long)0L, (long)size);
        HashMap<byte[], GeoCoordinate> bcoordinateMap = new HashMap<byte[], GeoCoordinate>();
        bcoordinateMap.put(this.bA, new GeoCoordinate(3.0, 4.0));
        bcoordinateMap.put(this.bB, new GeoCoordinate(2.0, 3.0));
        bcoordinateMap.put(this.bC, new GeoCoordinate(3.314, 2.3241));
        size = this.jedis.geoadd(this.bfoo, bcoordinateMap);
        GeoCommandsTest.assertEquals((long)2L, (long)size);
    }

    @Test
    public void geodist() {
        this.prepareGeoData();
        Double dist = this.jedis.geodist("foo", "a", "b");
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)157149L);
        dist = this.jedis.geodist("foo", "a", "b", GeoUnit.KM);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)157L);
        dist = this.jedis.geodist("foo", "a", "b", GeoUnit.MI);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)97L);
        dist = this.jedis.geodist("foo", "a", "b", GeoUnit.FT);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)515583L);
        dist = this.jedis.geodist(this.bfoo, this.bA, this.bB);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)157149L);
        dist = this.jedis.geodist(this.bfoo, this.bA, this.bB, GeoUnit.KM);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)157L);
        dist = this.jedis.geodist(this.bfoo, this.bA, this.bB, GeoUnit.MI);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)97L);
        dist = this.jedis.geodist(this.bfoo, this.bA, this.bB, GeoUnit.FT);
        GeoCommandsTest.assertEquals((long)dist.intValue(), (long)515583L);
    }

    @Test
    public void geohash() {
        this.prepareGeoData();
        List<String> hashes = this.jedis.geohash("foo", "a", "b", "notexist");
        GeoCommandsTest.assertEquals((long)3L, (long)hashes.size());
        GeoCommandsTest.assertEquals((Object)"s0dnu20t9j0", (Object)hashes.get(0));
        GeoCommandsTest.assertEquals((Object)"s093jd0k720", (Object)hashes.get(1));
        GeoCommandsTest.assertNull((Object)hashes.get(2));
        List<byte[]> bhashes = this.jedis.geohash(this.bfoo, this.bA, this.bB, this.bNotexist);
        GeoCommandsTest.assertEquals((long)3L, (long)bhashes.size());
        GeoCommandsTest.assertArrayEquals((byte[])SafeEncoder.encode("s0dnu20t9j0"), (byte[])bhashes.get(0));
        GeoCommandsTest.assertArrayEquals((byte[])SafeEncoder.encode("s093jd0k720"), (byte[])bhashes.get(1));
        GeoCommandsTest.assertNull((Object)bhashes.get(2));
    }

    @Test
    public void geopos() {
        this.prepareGeoData();
        List<GeoCoordinate> coordinates = this.jedis.geopos("foo", "a", "b", "notexist");
        GeoCommandsTest.assertEquals((long)3L, (long)coordinates.size());
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(3.0, coordinates.get(0).getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(4.0, coordinates.get(0).getLatitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(2.0, coordinates.get(1).getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(3.0, coordinates.get(1).getLatitude()));
        GeoCommandsTest.assertNull((Object)coordinates.get(2));
        List<GeoCoordinate> bcoordinates = this.jedis.geopos(this.bfoo, this.bA, this.bB, this.bNotexist);
        GeoCommandsTest.assertEquals((long)3L, (long)bcoordinates.size());
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(3.0, bcoordinates.get(0).getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(4.0, bcoordinates.get(0).getLatitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(2.0, bcoordinates.get(1).getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(3.0, bcoordinates.get(1).getLatitude()));
        GeoCommandsTest.assertNull((Object)bcoordinates.get(2));
    }

    @Test
    public void georadius() {
        HashMap<String, GeoCoordinate> coordinateMap = new HashMap<String, GeoCoordinate>();
        coordinateMap.put("Palermo", new GeoCoordinate(13.361389, 38.115556));
        coordinateMap.put("Catania", new GeoCoordinate(15.087269, 37.502669));
        this.jedis.geoadd("Sicily", coordinateMap);
        List<GeoRadiusResponse> members = this.jedis.georadius("Sicily", 15.0, 37.0, 200.0, GeoUnit.KM);
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        members = this.jedis.georadius("Sicily", 15.0, 37.0, 200.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending());
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        GeoCommandsTest.assertEquals((Object)"Catania", (Object)members.get(0).getMemberByString());
        GeoCommandsTest.assertEquals((Object)"Palermo", (Object)members.get(1).getMemberByString());
        members = this.jedis.georadius("Sicily", 15.0, 37.0, 200.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending().count(1));
        GeoCommandsTest.assertEquals((long)1L, (long)members.size());
        members = this.jedis.georadius("Sicily", 15.0, 37.0, 200.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending().count(1).withCoord().withDist());
        GeoCommandsTest.assertEquals((long)1L, (long)members.size());
        GeoRadiusResponse response = members.get(0);
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(56.4413, response.getDistance()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(15.087269, response.getCoordinate().getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(37.502669, response.getCoordinate().getLatitude()));
    }

    @Test
    public void georadiusBinary() {
        HashMap<byte[], GeoCoordinate> bcoordinateMap = new HashMap<byte[], GeoCoordinate>();
        bcoordinateMap.put(this.bA, new GeoCoordinate(13.361389, 38.115556));
        bcoordinateMap.put(this.bB, new GeoCoordinate(15.087269, 37.502669));
        this.jedis.geoadd(this.bfoo, bcoordinateMap);
        List<GeoRadiusResponse> members = this.jedis.georadius(this.bfoo, 15.0, 37.0, 200.0, GeoUnit.KM);
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        members = this.jedis.georadius(this.bfoo, 15.0, 37.0, 200.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending());
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        GeoCommandsTest.assertArrayEquals((byte[])this.bB, (byte[])members.get(0).getMember());
        GeoCommandsTest.assertArrayEquals((byte[])this.bA, (byte[])members.get(1).getMember());
        members = this.jedis.georadius(this.bfoo, 15.0, 37.0, 200.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending().count(1));
        GeoCommandsTest.assertEquals((long)1L, (long)members.size());
        members = this.jedis.georadius(this.bfoo, 15.0, 37.0, 200.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending().count(1).withCoord().withDist());
        GeoCommandsTest.assertEquals((long)1L, (long)members.size());
        GeoRadiusResponse response = members.get(0);
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(56.4413, response.getDistance()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(15.087269, response.getCoordinate().getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(37.502669, response.getCoordinate().getLatitude()));
    }

    @Test
    public void georadiusByMember() {
        this.jedis.geoadd("Sicily", 13.583333, 37.316667, "Agrigento");
        this.jedis.geoadd("Sicily", 13.361389, 38.115556, "Palermo");
        this.jedis.geoadd("Sicily", 15.087269, 37.502669, "Catania");
        List<GeoRadiusResponse> members = this.jedis.georadiusByMember("Sicily", "Agrigento", 100.0, GeoUnit.KM);
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        members = this.jedis.georadiusByMember("Sicily", "Agrigento", 100.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending());
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        GeoCommandsTest.assertEquals((Object)"Agrigento", (Object)members.get(0).getMemberByString());
        GeoCommandsTest.assertEquals((Object)"Palermo", (Object)members.get(1).getMemberByString());
        members = this.jedis.georadiusByMember("Sicily", "Agrigento", 100.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending().count(1).withCoord().withDist());
        GeoCommandsTest.assertEquals((long)1L, (long)members.size());
        GeoRadiusResponse member = members.get(0);
        GeoCommandsTest.assertEquals((Object)"Agrigento", (Object)member.getMemberByString());
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(0.0, member.getDistance()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(13.583333, member.getCoordinate().getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(37.316667, member.getCoordinate().getLatitude()));
    }

    @Test
    public void georadiusByMemberBinary() {
        this.jedis.geoadd(this.bfoo, 13.583333, 37.316667, this.bA);
        this.jedis.geoadd(this.bfoo, 13.361389, 38.115556, this.bB);
        this.jedis.geoadd(this.bfoo, 15.087269, 37.502669, this.bC);
        List<GeoRadiusResponse> members = this.jedis.georadiusByMember(this.bfoo, this.bA, 100.0, GeoUnit.KM);
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        members = this.jedis.georadiusByMember(this.bfoo, this.bA, 100.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending());
        GeoCommandsTest.assertEquals((long)2L, (long)members.size());
        GeoCommandsTest.assertArrayEquals((byte[])this.bA, (byte[])members.get(0).getMember());
        GeoCommandsTest.assertArrayEquals((byte[])this.bB, (byte[])members.get(1).getMember());
        members = this.jedis.georadiusByMember(this.bfoo, this.bA, 100.0, GeoUnit.KM, GeoRadiusParam.geoRadiusParam().sortAscending().count(1).withCoord().withDist());
        GeoCommandsTest.assertEquals((long)1L, (long)members.size());
        GeoRadiusResponse member = members.get(0);
        GeoCommandsTest.assertArrayEquals((byte[])this.bA, (byte[])member.getMember());
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(0.0, member.getDistance()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(13.583333, member.getCoordinate().getLongitude()));
        GeoCommandsTest.assertTrue((boolean)this.equalsWithinEpsilon(37.316667, member.getCoordinate().getLatitude()));
    }

    private void prepareGeoData() {
        HashMap<String, GeoCoordinate> coordinateMap = new HashMap<String, GeoCoordinate>();
        coordinateMap.put("a", new GeoCoordinate(3.0, 4.0));
        coordinateMap.put("b", new GeoCoordinate(2.0, 3.0));
        coordinateMap.put("c", new GeoCoordinate(3.314, 2.3241));
        long size = this.jedis.geoadd("foo", coordinateMap);
        GeoCommandsTest.assertEquals((long)3L, (long)size);
        HashMap<byte[], GeoCoordinate> bcoordinateMap = new HashMap<byte[], GeoCoordinate>();
        bcoordinateMap.put(this.bA, new GeoCoordinate(3.0, 4.0));
        bcoordinateMap.put(this.bB, new GeoCoordinate(2.0, 3.0));
        bcoordinateMap.put(this.bC, new GeoCoordinate(3.314, 2.3241));
        size = this.jedis.geoadd(this.bfoo, bcoordinateMap);
        GeoCommandsTest.assertEquals((long)3L, (long)size);
    }

    private boolean equalsWithinEpsilon(double d1, double d2) {
        double epsilon = 1.0E-5;
        return Math.abs(d1 - d2) < epsilon;
    }
}

