/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.List;
import org.junit.Test;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class ControlCommandsTest
extends JedisCommandTestBase {
    @Test
    public void save() {
        try {
            String status = this.jedis.save();
            ControlCommandsTest.assertEquals((Object)"OK", (Object)status);
        }
        catch (JedisDataException e) {
            ControlCommandsTest.assertTrue((boolean)"ERR Background save already in progress".equalsIgnoreCase(e.getMessage()));
        }
    }

    @Test
    public void bgsave() {
        try {
            String status = this.jedis.bgsave();
            ControlCommandsTest.assertEquals((Object)"Background saving started", (Object)status);
        }
        catch (JedisDataException e) {
            ControlCommandsTest.assertTrue((boolean)"ERR Background save already in progress".equalsIgnoreCase(e.getMessage()));
        }
    }

    @Test
    public void bgrewriteaof() {
        String scheduled = "Background append only file rewriting scheduled";
        String started = "Background append only file rewriting started";
        String status = this.jedis.bgrewriteaof();
        boolean ok = status.equals(scheduled) || status.equals(started);
        ControlCommandsTest.assertTrue((boolean)ok);
    }

    @Test
    public void lastsave() throws InterruptedException {
        long saved = this.jedis.lastsave();
        ControlCommandsTest.assertTrue((saved > 0L ? 1 : 0) != 0);
    }

    @Test
    public void info() {
        String info = this.jedis.info();
        ControlCommandsTest.assertNotNull((Object)info);
        info = this.jedis.info("server");
        ControlCommandsTest.assertNotNull((Object)info);
    }

    @Test
    public void readonly() {
        try {
            this.jedis.readonly();
        }
        catch (JedisDataException e) {
            ControlCommandsTest.assertTrue((boolean)"ERR This instance has cluster support disabled".equalsIgnoreCase(e.getMessage()));
        }
    }

    @Test
    public void monitor() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Jedis j = new Jedis("localhost");
                j.auth("foobared");
                int i = 0;
                while (i < 5) {
                    j.incr("foobared");
                    ++i;
                }
                j.disconnect();
            }
        }).start();
        this.jedis.monitor(new JedisMonitor(){
            private int count = 0;

            @Override
            public void onCommand(String command) {
                if (command.contains("INCR")) {
                    ++this.count;
                }
                if (this.count == 5) {
                    this.client.disconnect();
                }
            }
        });
    }

    @Test
    public void configGet() {
        List<String> info = this.jedis.configGet("m*");
        ControlCommandsTest.assertNotNull(info);
    }

    @Test
    public void configSet() {
        List<String> info = this.jedis.configGet("maxmemory");
        String memory = info.get(1);
        String status = this.jedis.configSet("maxmemory", "200");
        ControlCommandsTest.assertEquals((Object)"OK", (Object)status);
        this.jedis.configSet("maxmemory", memory);
    }

    @Test
    public void sync() {
        this.jedis.sync();
    }

    @Test
    public void debug() {
        this.jedis.set("foo", "bar");
        String resp = this.jedis.debug(DebugParams.OBJECT("foo"));
        ControlCommandsTest.assertNotNull((Object)resp);
        resp = this.jedis.debug(DebugParams.RELOAD());
        ControlCommandsTest.assertNotNull((Object)resp);
    }

    @Test
    public void waitReplicas() {
        Long replicas = this.jedis.waitReplicas(1, 100L);
        ControlCommandsTest.assertEquals((long)1L, (long)replicas);
    }
}

