/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.JedisTestBase;
import redis.clients.util.JedisClusterCRC16;

public class ClusterScriptingCommandsTest
extends JedisTestBase {
    private Jedis node1;
    private static Jedis node2;
    private static Jedis node3;
    private HostAndPort nodeInfo1 = HostAndPortUtil.getClusterServers().get(0);
    private HostAndPort nodeInfo2 = HostAndPortUtil.getClusterServers().get(1);
    private HostAndPort nodeInfo3 = HostAndPortUtil.getClusterServers().get(2);
    private final Set<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
    JedisCluster jedisCluster;

    @Before
    public void setUp() throws InterruptedException {
        this.node1 = new Jedis(this.nodeInfo1.getHost(), this.nodeInfo1.getPort());
        this.node1.connect();
        this.node1.flushAll();
        node2 = new Jedis(this.nodeInfo2.getHost(), this.nodeInfo2.getPort());
        node2.connect();
        node2.flushAll();
        node3 = new Jedis(this.nodeInfo3.getHost(), this.nodeInfo3.getPort());
        node3.connect();
        node3.flushAll();
        this.node1.clusterMeet("127.0.0.1", this.nodeInfo2.getPort());
        this.node1.clusterMeet("127.0.0.1", this.nodeInfo3.getPort());
        int slotsPerNode = 5461;
        int[] node1Slots = new int[slotsPerNode];
        int[] node2Slots = new int[slotsPerNode + 1];
        int[] node3Slots = new int[slotsPerNode];
        int i = 0;
        int slot1 = 0;
        int slot2 = 0;
        int slot3 = 0;
        while (i < 16384) {
            if (i < slotsPerNode) {
                node1Slots[slot1++] = i;
            } else if (i > slotsPerNode * 2) {
                node3Slots[slot3++] = i;
            } else {
                node2Slots[slot2++] = i;
            }
            ++i;
        }
        this.node1.clusterAddSlots(node1Slots);
        node2.clusterAddSlots(node2Slots);
        node3.clusterAddSlots(node3Slots);
        this.waitForClusterReady();
        this.jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        this.jedisCluster = new JedisCluster(this.jedisClusterNode);
    }

    @AfterClass
    public static void cleanUp() {
        int slotTest = JedisClusterCRC16.getSlot("test");
        int slot51 = JedisClusterCRC16.getSlot("51");
        String node3Id = ClusterScriptingCommandsTest.getNodeId(node3.clusterNodes());
        node2.clusterSetSlotNode(slotTest, node3Id);
        node2.clusterSetSlotNode(slot51, node3Id);
        node2.clusterDelSlots(slotTest, slot51);
    }

    @After
    public void tearDown() {
        int[] slotsToDelete = new int[16384];
        int i = 0;
        while (i < 16384) {
            slotsToDelete[i] = i;
            ++i;
        }
        this.node1.clusterDelSlots(slotsToDelete);
        node2.clusterDelSlots(slotsToDelete);
        node3.clusterDelSlots(slotsToDelete);
    }

    @Test(expected=JedisClusterException.class)
    public void testJedisClusterException() {
        String script = "return {KEYS[1],KEYS[2],ARGV[1],ARGV[2],ARGV[3]}";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key1");
        keys.add("key2");
        ArrayList<String> args = new ArrayList<String>();
        args.add("first");
        args.add("second");
        args.add("third");
        this.jedisCluster.eval(script, keys, args);
    }

    @Test
    public void testEval2() {
        String script = "return redis.call('set',KEYS[1],'bar')";
        int numKeys = 1;
        String[] args = new String[]{"foo"};
        this.jedisCluster.eval(script, numKeys, args);
        ClusterScriptingCommandsTest.assertEquals((Object)this.jedisCluster.get("foo"), (Object)"bar");
    }

    @Test
    public void testScriptLoadAndScriptExists() {
        String sha1 = this.jedisCluster.scriptLoad("return redis.call('get','foo')", "key1");
        ClusterScriptingCommandsTest.assertTrue((boolean)this.jedisCluster.scriptExists(sha1, "key1"));
    }

    @Test
    public void testEvalsha() {
        String sha1 = this.jedisCluster.scriptLoad("return 10", "key1");
        Object o = this.jedisCluster.evalsha(sha1, 1, "key1");
        ClusterScriptingCommandsTest.assertEquals((Object)"10", (Object)o.toString());
    }

    @Test(expected=JedisClusterException.class)
    public void testJedisClusterException2() {
        byte[] script = "return {KEYS[1],KEYS[2],ARGV[1],ARGV[2],ARGV[3]}".getBytes();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        keys.add("key1".getBytes());
        keys.add("key2".getBytes());
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add("first".getBytes());
        args.add("second".getBytes());
        args.add("third".getBytes());
        this.jedisCluster.eval(script, keys, args);
    }

    @Test
    public void testBinaryEval() {
        byte[] script = "return redis.call('set',KEYS[1],'bar')".getBytes();
        byte[] args = "foo".getBytes();
        this.jedisCluster.eval(script, 1, (byte[][])new byte[][]{args});
        ClusterScriptingCommandsTest.assertEquals((Object)this.jedisCluster.get("foo"), (Object)"bar");
    }

    @Test
    public void testBinaryScriptFlush() {
        byte[] byteKey = "key1".getBytes();
        byte[] sha1 = this.jedisCluster.scriptLoad("return redis.call('get','foo')".getBytes(), byteKey);
        ClusterScriptingCommandsTest.assertEquals((Object)"OK", (Object)this.jedisCluster.scriptFlush(byteKey));
    }

    @Test(expected=JedisDataException.class)
    public void testBinaryScriptKill() {
        byte[] byteKey = "key1".getBytes();
        this.jedisCluster.scriptKill(byteKey);
    }

    @Test
    public void testBinaryScriptExists() {
        byte[] byteKey = "key1".getBytes();
        byte[] sha1 = this.jedisCluster.scriptLoad("return redis.call('get','foo')".getBytes(), byteKey);
        byte[][] arraySha1 = new byte[][]{sha1};
        Long result = 1L;
        ArrayList<Long> listResult = new ArrayList<Long>();
        listResult.add(result);
        ClusterScriptingCommandsTest.assertEquals(listResult, this.jedisCluster.scriptExists(byteKey, arraySha1));
    }

    private static String getNodeId(String infoOutput) {
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains("myself")) {
                return infoLine.split(" ")[0];
            }
            ++n2;
        }
        return "";
    }

    private void waitForClusterReady() throws InterruptedException {
        boolean clusterOk = false;
        while (!clusterOk) {
            if (this.node1.clusterInfo().split("\n")[0].contains("ok") && node2.clusterInfo().split("\n")[0].contains("ok") && node3.clusterInfo().split("\n")[0].contains("ok")) {
                clusterOk = true;
            }
            Thread.sleep(50L);
        }
    }
}

