/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.JedisTestBase;
import redis.clients.jedis.tests.utils.JedisClusterTestUtil;

public class ClusterCommandsTest
extends JedisTestBase {
    private static Jedis node1;
    private static Jedis node2;
    private HostAndPort nodeInfo1 = HostAndPortUtil.getClusterServers().get(0);
    private HostAndPort nodeInfo2 = HostAndPortUtil.getClusterServers().get(1);

    @Before
    public void setUp() throws Exception {
        node1 = new Jedis(this.nodeInfo1.getHost(), this.nodeInfo1.getPort());
        node1.connect();
        node1.flushAll();
        node2 = new Jedis(this.nodeInfo2.getHost(), this.nodeInfo2.getPort());
        node2.connect();
        node2.flushAll();
    }

    @After
    public void tearDown() {
        node1.disconnect();
        node2.disconnect();
    }

    @AfterClass
    public static void removeSlots() throws InterruptedException {
        node1.clusterReset(JedisCluster.Reset.SOFT);
        node2.clusterReset(JedisCluster.Reset.SOFT);
    }

    @Test
    public void testClusterSoftReset() {
        node1.clusterMeet("127.0.0.1", this.nodeInfo2.getPort());
        ClusterCommandsTest.assertTrue((node1.clusterNodes().split("\n").length > 1 ? 1 : 0) != 0);
        node1.clusterReset(JedisCluster.Reset.SOFT);
        ClusterCommandsTest.assertEquals((long)1L, (long)node1.clusterNodes().split("\n").length);
    }

    @Test
    public void testClusterHardReset() {
        String nodeId = JedisClusterTestUtil.getNodeId(node1.clusterNodes());
        node1.clusterReset(JedisCluster.Reset.HARD);
        String newNodeId = JedisClusterTestUtil.getNodeId(node1.clusterNodes());
        ClusterCommandsTest.assertNotEquals((Object)nodeId, (Object)newNodeId);
    }

    @Test
    public void clusterSetSlotImporting() {
        node2.clusterAddSlots(6000);
        String[] nodes = node1.clusterNodes().split("\n");
        String nodeId = nodes[0].split(" ")[0];
        String status = node1.clusterSetSlotImporting(6000, nodeId);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void clusterNodes() {
        String nodes = node1.clusterNodes();
        ClusterCommandsTest.assertTrue((nodes.split("\n").length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void clusterMeet() {
        String status = node1.clusterMeet("127.0.0.1", this.nodeInfo2.getPort());
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void clusterAddSlots() {
        String status = node1.clusterAddSlots(1, 2, 3, 4, 5);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void clusterDelSlots() {
        node1.clusterAddSlots(900);
        String status = node1.clusterDelSlots(900);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void clusterInfo() {
        String info = node1.clusterInfo();
        ClusterCommandsTest.assertNotNull((Object)info);
    }

    @Test
    public void clusterGetKeysInSlot() {
        node1.clusterAddSlots(500);
        List<String> keys = node1.clusterGetKeysInSlot(500, 1);
        ClusterCommandsTest.assertEquals((long)0L, (long)keys.size());
    }

    @Test
    public void clusterSetSlotNode() {
        String[] nodes = node1.clusterNodes().split("\n");
        String nodeId = nodes[0].split(" ")[0];
        String status = node1.clusterSetSlotNode(10000, nodeId);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void clusterSetSlotMigrating() {
        node1.clusterAddSlots(5000);
        String[] nodes = node1.clusterNodes().split("\n");
        String nodeId = nodes[0].split(" ")[0];
        String status = node1.clusterSetSlotMigrating(5000, nodeId);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void clusterSlots() {
        String status = node1.clusterAddSlots(3000, 3001, 3002);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
        status = node2.clusterAddSlots(4000, 4001, 4002);
        ClusterCommandsTest.assertEquals((Object)"OK", (Object)status);
        List<Object> slots = node1.clusterSlots();
        ClusterCommandsTest.assertNotNull(slots);
        ClusterCommandsTest.assertTrue((!slots.isEmpty() ? 1 : 0) != 0);
        for (Object slotInfoObj : slots) {
            List slotInfo = (List)slotInfoObj;
            ClusterCommandsTest.assertNotNull(slots);
            ClusterCommandsTest.assertTrue((slots.size() >= 2 ? 1 : 0) != 0);
            ClusterCommandsTest.assertTrue((boolean)(slotInfo.get(0) instanceof Long));
            ClusterCommandsTest.assertTrue((boolean)(slotInfo.get(1) instanceof Long));
            if (slots.size() <= 2) continue;
            ClusterCommandsTest.assertTrue((boolean)(slotInfo.get(2) instanceof List));
        }
    }
}

