/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.JedisTestBase;
import redis.clients.util.JedisClusterCRC16;

public class ClusterBinaryJedisCommandsTest
extends JedisTestBase {
    private Jedis node1;
    private static Jedis node2;
    private static Jedis node3;
    private HostAndPort nodeInfo1 = HostAndPortUtil.getClusterServers().get(0);
    private HostAndPort nodeInfo2 = HostAndPortUtil.getClusterServers().get(1);
    private HostAndPort nodeInfo3 = HostAndPortUtil.getClusterServers().get(2);
    private final Set<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
    JedisCluster jedisCluster;

    @Before
    public void setUp() throws InterruptedException {
        this.node1 = new Jedis(this.nodeInfo1.getHost(), this.nodeInfo1.getPort());
        this.node1.connect();
        this.node1.flushAll();
        node2 = new Jedis(this.nodeInfo2.getHost(), this.nodeInfo2.getPort());
        node2.connect();
        node2.flushAll();
        node3 = new Jedis(this.nodeInfo3.getHost(), this.nodeInfo3.getPort());
        node3.connect();
        node3.flushAll();
        this.node1.clusterMeet("127.0.0.1", this.nodeInfo2.getPort());
        this.node1.clusterMeet("127.0.0.1", this.nodeInfo3.getPort());
        int slotsPerNode = 5461;
        int[] node1Slots = new int[slotsPerNode];
        int[] node2Slots = new int[slotsPerNode + 1];
        int[] node3Slots = new int[slotsPerNode];
        int i = 0;
        int slot1 = 0;
        int slot2 = 0;
        int slot3 = 0;
        while (i < 16384) {
            if (i < slotsPerNode) {
                node1Slots[slot1++] = i;
            } else if (i > slotsPerNode * 2) {
                node3Slots[slot3++] = i;
            } else {
                node2Slots[slot2++] = i;
            }
            ++i;
        }
        this.node1.clusterAddSlots(node1Slots);
        node2.clusterAddSlots(node2Slots);
        node3.clusterAddSlots(node3Slots);
        this.waitForClusterReady();
        this.jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        this.jedisCluster = new JedisCluster(this.jedisClusterNode);
    }

    @AfterClass
    public static void cleanUp() {
        int slotTest = JedisClusterCRC16.getSlot("test");
        int slot51 = JedisClusterCRC16.getSlot("51");
        String node3Id = ClusterBinaryJedisCommandsTest.getNodeId(node3.clusterNodes());
        node2.clusterSetSlotNode(slotTest, node3Id);
        node2.clusterSetSlotNode(slot51, node3Id);
        node2.clusterDelSlots(slotTest, slot51);
    }

    @After
    public void tearDown() {
        int[] slotsToDelete = new int[16384];
        int i = 0;
        while (i < 16384) {
            slotsToDelete[i] = i;
            ++i;
        }
        this.node1.clusterDelSlots(slotsToDelete);
        node2.clusterDelSlots(slotsToDelete);
        node3.clusterDelSlots(slotsToDelete);
    }

    @Test
    public void testBinaryGetAndSet() {
        byte[] byteKey = "foo".getBytes();
        byte[] byteValue = "2".getBytes();
        this.jedisCluster.set(byteKey, byteValue);
        ClusterBinaryJedisCommandsTest.assertEquals((Object)new String(this.jedisCluster.get(byteKey)), (Object)"2");
    }

    @Test
    public void testIncr() {
        byte[] byteKey = "foo".getBytes();
        byte[] byteValue = "2".getBytes();
        this.jedisCluster.set(byteKey, byteValue);
        this.jedisCluster.incr(byteKey);
        ClusterBinaryJedisCommandsTest.assertEquals((Object)new String(this.jedisCluster.get(byteKey)), (Object)"3");
    }

    @Test
    public void testSadd() {
        byte[] byteKey = "languages".getBytes();
        byte[] firstLanguage = "java".getBytes();
        byte[] secondLanguage = "python".getBytes();
        byte[][] listLanguages = new byte[][]{firstLanguage, secondLanguage};
        this.jedisCluster.sadd(byteKey, listLanguages);
        Set<byte[]> setLanguages = this.jedisCluster.smembers(byteKey);
        ArrayList<String> languages = new ArrayList<String>();
        for (byte[] language : setLanguages) {
            languages.add(new String(language));
        }
        ClusterBinaryJedisCommandsTest.assertTrue((boolean)languages.contains("java"));
        ClusterBinaryJedisCommandsTest.assertTrue((boolean)languages.contains("python"));
    }

    @Test
    public void testHmset() {
        byte[] byteKey = "language".getBytes();
        byte[] language = "java".getBytes();
        HashMap<byte[], byte[]> map = new HashMap<byte[], byte[]>();
        map.put(byteKey, language);
        this.jedisCluster.hmset(byteKey, map);
        List<byte[]> listResults = this.jedisCluster.hmget(byteKey, new byte[][]{byteKey});
        for (byte[] result : listResults) {
            String resultString = new String(result);
            ClusterBinaryJedisCommandsTest.assertEquals((Object)resultString, (Object)"java");
        }
    }

    @Test
    public void testRpush() {
        byte[] value1 = "value1".getBytes();
        byte[] value2 = "value2".getBytes();
        byte[] key = "key1".getBytes();
        this.jedisCluster.del(key);
        this.jedisCluster.rpush(key, new byte[][]{value1});
        this.jedisCluster.rpush(key, new byte[][]{value2});
        long num = 2L;
        ClusterBinaryJedisCommandsTest.assertEquals((long)2L, (long)this.jedisCluster.llen(key));
    }

    @Test
    public void testGetSlot() {
        ClusterBinaryJedisCommandsTest.assertEquals((long)JedisClusterCRC16.getSlot("{bar".getBytes()), (long)JedisClusterCRC16.getSlot("{bar"));
        ClusterBinaryJedisCommandsTest.assertEquals((long)JedisClusterCRC16.getSlot("{user1000}.following".getBytes()), (long)JedisClusterCRC16.getSlot("{user1000}.followers".getBytes()));
        ClusterBinaryJedisCommandsTest.assertNotEquals((long)JedisClusterCRC16.getSlot("foo{}{bar}".getBytes()), (long)JedisClusterCRC16.getSlot("bar".getBytes()));
        ClusterBinaryJedisCommandsTest.assertEquals((long)JedisClusterCRC16.getSlot("foo{bar}{zap}".getBytes()), (long)JedisClusterCRC16.getSlot("bar".getBytes()));
    }

    private static String getNodeId(String infoOutput) {
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains("myself")) {
                return infoLine.split(" ")[0];
            }
            ++n2;
        }
        return "";
    }

    private void waitForClusterReady() throws InterruptedException {
        boolean clusterOk = false;
        while (!clusterOk) {
            if (this.node1.clusterInfo().split("\n")[0].contains("ok") && node2.clusterInfo().split("\n")[0].contains("ok") && node3.clusterInfo().split("\n")[0].contains("ok")) {
                clusterOk = true;
            }
            Thread.sleep(50L);
        }
    }
}

