/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import org.junit.Test;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class BitCommandsTest
extends JedisCommandTestBase {
    @Test
    public void setAndgetbit() {
        boolean bit = this.jedis.setbit("foo", 0L, true);
        BitCommandsTest.assertEquals((Object)false, (Object)bit);
        bit = this.jedis.getbit("foo", 0L);
        BitCommandsTest.assertEquals((Object)true, (Object)bit);
        boolean bbit = this.jedis.setbit("bfoo".getBytes(), 0L, "1".getBytes());
        BitCommandsTest.assertFalse((boolean)bbit);
        bbit = this.jedis.getbit("bfoo".getBytes(), 0L);
        BitCommandsTest.assertTrue((boolean)bbit);
    }

    @Test
    public void bitpos() {
        String foo = "foo";
        this.jedis.set(foo, String.valueOf(0));
        this.jedis.setbit(foo, 3L, true);
        this.jedis.setbit(foo, 7L, true);
        this.jedis.setbit(foo, 13L, true);
        this.jedis.setbit(foo, 39L, true);
        long offset = this.jedis.bitpos(foo, true);
        BitCommandsTest.assertEquals((long)2L, (long)offset);
        offset = this.jedis.bitpos(foo, false);
        BitCommandsTest.assertEquals((long)0L, (long)offset);
        offset = this.jedis.bitpos(foo, true, new BitPosParams(1L));
        BitCommandsTest.assertEquals((long)13L, (long)offset);
        offset = this.jedis.bitpos(foo, false, new BitPosParams(1L));
        BitCommandsTest.assertEquals((long)8L, (long)offset);
        offset = this.jedis.bitpos(foo, true, new BitPosParams(2L, 3L));
        BitCommandsTest.assertEquals((long)-1L, (long)offset);
        offset = this.jedis.bitpos(foo, false, new BitPosParams(2L, 3L));
        BitCommandsTest.assertEquals((long)16L, (long)offset);
        offset = this.jedis.bitpos(foo, true, new BitPosParams(3L, 4L));
        BitCommandsTest.assertEquals((long)39L, (long)offset);
    }

    @Test
    public void bitposBinary() {
        byte[] bfoo = new byte[]{1, 2, 3, 4};
        this.jedis.set(bfoo, Protocol.toByteArray(0));
        this.jedis.setbit(bfoo, 3L, true);
        this.jedis.setbit(bfoo, 7L, true);
        this.jedis.setbit(bfoo, 13L, true);
        this.jedis.setbit(bfoo, 39L, true);
        long offset = this.jedis.bitpos(bfoo, true);
        BitCommandsTest.assertEquals((long)2L, (long)offset);
        offset = this.jedis.bitpos(bfoo, false);
        BitCommandsTest.assertEquals((long)0L, (long)offset);
        offset = this.jedis.bitpos(bfoo, true, new BitPosParams(1L));
        BitCommandsTest.assertEquals((long)13L, (long)offset);
        offset = this.jedis.bitpos(bfoo, false, new BitPosParams(1L));
        BitCommandsTest.assertEquals((long)8L, (long)offset);
        offset = this.jedis.bitpos(bfoo, true, new BitPosParams(2L, 3L));
        BitCommandsTest.assertEquals((long)-1L, (long)offset);
        offset = this.jedis.bitpos(bfoo, false, new BitPosParams(2L, 3L));
        BitCommandsTest.assertEquals((long)16L, (long)offset);
        offset = this.jedis.bitpos(bfoo, true, new BitPosParams(3L, 4L));
        BitCommandsTest.assertEquals((long)39L, (long)offset);
    }

    @Test
    public void bitposWithNoMatchingBitExist() {
        String foo = "foo";
        this.jedis.set(foo, String.valueOf(0));
        int idx = 0;
        while (idx < 8) {
            this.jedis.setbit(foo, (long)idx, true);
            ++idx;
        }
        long offset = this.jedis.bitpos(foo, false);
        BitCommandsTest.assertEquals((long)8L, (long)offset);
    }

    @Test
    public void bitposWithNoMatchingBitExistWithinRange() {
        String foo = "foo";
        this.jedis.set(foo, String.valueOf(0));
        int idx = 0;
        while (idx < 40) {
            this.jedis.setbit(foo, (long)idx, true);
            ++idx;
        }
        long offset = this.jedis.bitpos(foo, false, new BitPosParams(2L, 3L));
        BitCommandsTest.assertEquals((long)-1L, (long)offset);
    }

    @Test
    public void setAndgetrange() {
        this.jedis.set("key1", "Hello World");
        long reply = this.jedis.setrange("key1", 6L, "Jedis");
        BitCommandsTest.assertEquals((long)11L, (long)reply);
        BitCommandsTest.assertEquals((Object)this.jedis.get("key1"), (Object)"Hello Jedis");
        BitCommandsTest.assertEquals((Object)"Hello", (Object)this.jedis.getrange("key1", 0L, 4L));
        BitCommandsTest.assertEquals((Object)"Jedis", (Object)this.jedis.getrange("key1", 6L, 11L));
    }

    @Test
    public void bitCount() {
        this.jedis.del("foo");
        this.jedis.setbit("foo", 16L, true);
        this.jedis.setbit("foo", 24L, true);
        this.jedis.setbit("foo", 40L, true);
        this.jedis.setbit("foo", 56L, true);
        long c4 = this.jedis.bitcount("foo");
        BitCommandsTest.assertEquals((long)4L, (long)c4);
        long c3 = this.jedis.bitcount("foo", 2L, 5L);
        BitCommandsTest.assertEquals((long)3L, (long)c3);
        this.jedis.del("foo");
    }

    @Test
    public void bitOp() {
        this.jedis.set("key1", "`");
        this.jedis.set("key2", "D");
        this.jedis.bitop(BitOP.AND, "resultAnd", "key1", "key2");
        String resultAnd = this.jedis.get("resultAnd");
        BitCommandsTest.assertEquals((Object)"@", (Object)resultAnd);
        this.jedis.bitop(BitOP.OR, "resultOr", "key1", "key2");
        String resultOr = this.jedis.get("resultOr");
        BitCommandsTest.assertEquals((Object)"d", (Object)resultOr);
        this.jedis.bitop(BitOP.XOR, "resultXor", "key1", "key2");
        String resultXor = this.jedis.get("resultXor");
        BitCommandsTest.assertEquals((Object)"$", (Object)resultXor);
        this.jedis.del("resultAnd");
        this.jedis.del("resultOr");
        this.jedis.del("resultXor");
        this.jedis.del("key1");
        this.jedis.del("key2");
    }

    @Test
    public void bitOpNot() {
        this.jedis.del("key");
        this.jedis.setbit("key", 0L, true);
        this.jedis.setbit("key", 4L, true);
        this.jedis.bitop(BitOP.NOT, "resultNot", "key");
        String resultNot = this.jedis.get("resultNot");
        BitCommandsTest.assertEquals((Object)"w", (Object)resultNot);
        this.jedis.del("key");
        this.jedis.del("resultNot");
    }
}

