/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class BinaryValuesCommandsTest
extends JedisCommandTestBase {
    byte[] bfoo = new byte[]{1, 2, 3, 4};
    byte[] bbar = new byte[]{5, 6, 7, 8};
    byte[] bxx = new byte[]{120, 120};
    byte[] bnx = new byte[]{110, 120};
    byte[] bex = new byte[]{101, 120};
    byte[] bpx = new byte[]{112, 120};
    long expireSeconds = 2L;
    long expireMillis = this.expireSeconds * 1000L;
    byte[] binaryValue;

    @Before
    public void startUp() {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        while (n < 1000) {
            sb.append("A");
            ++n;
        }
        this.binaryValue = sb.toString().getBytes();
    }

    @Test
    public void setAndGet() {
        String status = this.jedis.set(this.bfoo, this.binaryValue);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        byte[] value = this.jedis.get(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, value));
        BinaryValuesCommandsTest.assertNull((Object)this.jedis.get(this.bbar));
    }

    @Test
    public void setNxExAndGet() {
        String status = this.jedis.set(this.bfoo, this.binaryValue, this.bnx, this.bex, this.expireSeconds);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        byte[] value = this.jedis.get(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, value));
        BinaryValuesCommandsTest.assertNull((Object)this.jedis.get(this.bbar));
    }

    @Test
    public void setIfNotExistAndGet() {
        String status = this.jedis.set(this.bfoo, this.binaryValue);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        String statusFail = this.jedis.set(this.bfoo, this.binaryValue, this.bnx, this.bex, this.expireSeconds);
        BinaryValuesCommandsTest.assertNull((Object)statusFail);
        byte[] value = this.jedis.get(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, value));
        BinaryValuesCommandsTest.assertNull((Object)this.jedis.get(this.bbar));
    }

    @Test
    public void setIfExistAndGet() {
        String status = this.jedis.set(this.bfoo, this.binaryValue);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        String statusSuccess = this.jedis.set(this.bfoo, this.binaryValue, this.bxx, this.bex, this.expireSeconds);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(statusSuccess));
        byte[] value = this.jedis.get(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, value));
        BinaryValuesCommandsTest.assertNull((Object)this.jedis.get(this.bbar));
    }

    @Test
    public void setFailIfNotExistAndGet() {
        String statusFail = this.jedis.set(this.bfoo, this.binaryValue, this.bxx, this.bex, this.expireSeconds);
        BinaryValuesCommandsTest.assertNull((Object)statusFail);
    }

    @Test
    public void setAndExpireMillis() {
        String status = this.jedis.set(this.bfoo, this.binaryValue, this.bnx, this.bpx, this.expireMillis);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        long ttl = this.jedis.ttl(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((ttl > 0L && ttl <= this.expireSeconds ? 1 : 0) != 0);
    }

    @Test
    public void setAndExpire() {
        String status = this.jedis.set(this.bfoo, this.binaryValue, this.bnx, this.bex, this.expireSeconds);
        BinaryValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        long ttl = this.jedis.ttl(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((ttl > 0L && ttl <= this.expireSeconds ? 1 : 0) != 0);
    }

    @Test
    public void getSet() {
        byte[] value = this.jedis.getSet(this.bfoo, this.binaryValue);
        BinaryValuesCommandsTest.assertNull((Object)value);
        value = this.jedis.get(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, value));
    }

    @Test
    public void mget() {
        List<byte[]> values = this.jedis.mget(this.bfoo, this.bbar);
        ArrayList<Object> expected = new ArrayList<byte[]>();
        expected.add(null);
        expected.add(null);
        this.assertEquals(expected, values);
        this.jedis.set(this.bfoo, this.binaryValue);
        expected = new ArrayList();
        expected.add(this.binaryValue);
        expected.add(null);
        values = this.jedis.mget(this.bfoo, this.bbar);
        this.assertEquals(expected, values);
        this.jedis.set(this.bbar, this.bfoo);
        expected = new ArrayList();
        expected.add(this.binaryValue);
        expected.add(this.bfoo);
        values = this.jedis.mget(this.bfoo, this.bbar);
        this.assertEquals(expected, values);
    }

    @Test
    public void setnx() {
        long status = this.jedis.setnx(this.bfoo, this.binaryValue);
        BinaryValuesCommandsTest.assertEquals((long)1L, (long)status);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.get(this.bfoo)));
        status = this.jedis.setnx(this.bfoo, this.bbar);
        BinaryValuesCommandsTest.assertEquals((long)0L, (long)status);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.get(this.bfoo)));
    }

    @Test
    public void setex() {
        String status = this.jedis.setex(this.bfoo, 20, this.binaryValue);
        BinaryValuesCommandsTest.assertEquals((Object)Protocol.Keyword.OK.name(), (Object)status);
        long ttl = this.jedis.ttl(this.bfoo);
        BinaryValuesCommandsTest.assertTrue((ttl > 0L && ttl <= 20L ? 1 : 0) != 0);
    }

    @Test
    public void mset() {
        String status = this.jedis.mset(this.bfoo, this.binaryValue, this.bbar, this.bfoo);
        BinaryValuesCommandsTest.assertEquals((Object)Protocol.Keyword.OK.name(), (Object)status);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.get(this.bfoo)));
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.bfoo, this.jedis.get(this.bbar)));
    }

    @Test
    public void msetnx() {
        long status = this.jedis.msetnx(this.bfoo, this.binaryValue, this.bbar, this.bfoo);
        BinaryValuesCommandsTest.assertEquals((long)1L, (long)status);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.get(this.bfoo)));
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.bfoo, this.jedis.get(this.bbar)));
        status = this.jedis.msetnx(this.bfoo, this.bbar, "bar2".getBytes(), "foo2".getBytes());
        BinaryValuesCommandsTest.assertEquals((long)0L, (long)status);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.get(this.bfoo)));
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.bfoo, this.jedis.get(this.bbar)));
    }

    @Test(expected=JedisDataException.class)
    public void incrWrongValue() {
        this.jedis.set(this.bfoo, this.binaryValue);
        this.jedis.incr(this.bfoo);
    }

    @Test
    public void incr() {
        long value = this.jedis.incr(this.bfoo);
        BinaryValuesCommandsTest.assertEquals((long)1L, (long)value);
        value = this.jedis.incr(this.bfoo);
        BinaryValuesCommandsTest.assertEquals((long)2L, (long)value);
    }

    @Test(expected=JedisDataException.class)
    public void incrByWrongValue() {
        this.jedis.set(this.bfoo, this.binaryValue);
        this.jedis.incrBy(this.bfoo, 2L);
    }

    @Test
    public void incrBy() {
        long value = this.jedis.incrBy(this.bfoo, 2L);
        BinaryValuesCommandsTest.assertEquals((long)2L, (long)value);
        value = this.jedis.incrBy(this.bfoo, 2L);
        BinaryValuesCommandsTest.assertEquals((long)4L, (long)value);
    }

    @Test(expected=JedisDataException.class)
    public void decrWrongValue() {
        this.jedis.set(this.bfoo, this.binaryValue);
        this.jedis.decr(this.bfoo);
    }

    @Test
    public void decr() {
        long value = this.jedis.decr(this.bfoo);
        BinaryValuesCommandsTest.assertEquals((long)-1L, (long)value);
        value = this.jedis.decr(this.bfoo);
        BinaryValuesCommandsTest.assertEquals((long)-2L, (long)value);
    }

    @Test(expected=JedisDataException.class)
    public void decrByWrongValue() {
        this.jedis.set(this.bfoo, this.binaryValue);
        this.jedis.decrBy(this.bfoo, 2L);
    }

    @Test
    public void decrBy() {
        long value = this.jedis.decrBy(this.bfoo, 2L);
        BinaryValuesCommandsTest.assertEquals((long)-2L, (long)value);
        value = this.jedis.decrBy(this.bfoo, 2L);
        BinaryValuesCommandsTest.assertEquals((long)-4L, (long)value);
    }

    @Test
    public void append() {
        byte[] first512 = new byte[512];
        System.arraycopy(this.binaryValue, 0, first512, 0, 512);
        long value = this.jedis.append(this.bfoo, first512);
        BinaryValuesCommandsTest.assertEquals((long)512L, (long)value);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(first512, this.jedis.get(this.bfoo)));
        byte[] rest = new byte[this.binaryValue.length - 512];
        System.arraycopy(this.binaryValue, 512, rest, 0, this.binaryValue.length - 512);
        value = this.jedis.append(this.bfoo, rest);
        BinaryValuesCommandsTest.assertEquals((long)this.binaryValue.length, (long)value);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.get(this.bfoo)));
    }

    @Test
    public void substr() {
        this.jedis.set(this.bfoo, this.binaryValue);
        byte[] first512 = new byte[512];
        System.arraycopy(this.binaryValue, 0, first512, 0, 512);
        byte[] rfirst512 = this.jedis.substr(this.bfoo, 0, 511);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(first512, rfirst512));
        byte[] last512 = new byte[512];
        System.arraycopy(this.binaryValue, this.binaryValue.length - 512, last512, 0, 512);
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(last512, this.jedis.substr(this.bfoo, -512, -1)));
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(this.binaryValue, this.jedis.substr(this.bfoo, 0, -1)));
        BinaryValuesCommandsTest.assertTrue((boolean)Arrays.equals(last512, this.jedis.substr(this.bfoo, this.binaryValue.length - 512, 100000)));
    }

    @Test
    public void strlen() {
        this.jedis.set(this.bfoo, this.binaryValue);
        BinaryValuesCommandsTest.assertEquals((long)this.binaryValue.length, (long)this.jedis.strlen(this.bfoo).intValue());
    }
}

