/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class AllKindOfValuesCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bfoo1 = new byte[]{1, 2, 3, 4, 10};
    final byte[] bfoo2 = new byte[]{1, 2, 3, 4, 11};
    final byte[] bfoo3 = new byte[]{1, 2, 3, 4, 12};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] bbar1 = new byte[]{5, 6, 7, 8, 10};
    final byte[] bbar2 = new byte[]{5, 6, 7, 8, 11};
    final byte[] bbar3 = new byte[]{5, 6, 7, 8, 12};
    final byte[] bfoobar = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    final byte[] bfoostar = new byte[]{1, 2, 3, 4, 42};
    final byte[] bbarstar = new byte[]{5, 6, 7, 8, 42};
    final byte[] bnx = new byte[]{110, 120};
    final byte[] bex = new byte[]{101, 120};
    final long expireSeconds = 2L;

    @Test
    public void ping() {
        String status = this.jedis.ping();
        AllKindOfValuesCommandsTest.assertEquals((Object)"PONG", (Object)status);
    }

    @Test
    public void exists() {
        String status = this.jedis.set("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        status = this.jedis.set(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        boolean reply = this.jedis.exists("foo");
        AllKindOfValuesCommandsTest.assertTrue((boolean)reply);
        reply = this.jedis.exists(this.bfoo);
        AllKindOfValuesCommandsTest.assertTrue((boolean)reply);
        long lreply = this.jedis.del("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)lreply);
        lreply = this.jedis.del(this.bfoo);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)lreply);
        reply = this.jedis.exists("foo");
        AllKindOfValuesCommandsTest.assertFalse((boolean)reply);
        reply = this.jedis.exists(this.bfoo);
        AllKindOfValuesCommandsTest.assertFalse((boolean)reply);
    }

    @Test
    public void existsMany() {
        String status = this.jedis.set("foo1", "bar1");
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        status = this.jedis.set("foo2", "bar2");
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        long reply = this.jedis.exists("foo1", "foo2");
        AllKindOfValuesCommandsTest.assertEquals((long)2L, (long)reply);
        long lreply = this.jedis.del("foo1");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)lreply);
        reply = this.jedis.exists("foo1", "foo2");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)reply);
    }

    @Test
    public void del() {
        this.jedis.set("foo1", "bar1");
        this.jedis.set("foo2", "bar2");
        this.jedis.set("foo3", "bar3");
        long reply = this.jedis.del("foo1", "foo2", "foo3");
        AllKindOfValuesCommandsTest.assertEquals((long)3L, (long)reply);
        Boolean breply = this.jedis.exists("foo1");
        AllKindOfValuesCommandsTest.assertFalse((boolean)breply);
        breply = this.jedis.exists("foo2");
        AllKindOfValuesCommandsTest.assertFalse((boolean)breply);
        breply = this.jedis.exists("foo3");
        AllKindOfValuesCommandsTest.assertFalse((boolean)breply);
        this.jedis.set("foo1", "bar1");
        reply = this.jedis.del("foo1", "foo2");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)reply);
        reply = this.jedis.del("foo1", "foo2");
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)reply);
        this.jedis.set(this.bfoo1, this.bbar1);
        this.jedis.set(this.bfoo2, this.bbar2);
        this.jedis.set(this.bfoo3, this.bbar3);
        reply = this.jedis.del(this.bfoo1, this.bfoo2, this.bfoo3);
        AllKindOfValuesCommandsTest.assertEquals((long)3L, (long)reply);
        breply = this.jedis.exists(this.bfoo1);
        AllKindOfValuesCommandsTest.assertFalse((boolean)breply);
        breply = this.jedis.exists(this.bfoo2);
        AllKindOfValuesCommandsTest.assertFalse((boolean)breply);
        breply = this.jedis.exists(this.bfoo3);
        AllKindOfValuesCommandsTest.assertFalse((boolean)breply);
        this.jedis.set(this.bfoo1, this.bbar1);
        reply = this.jedis.del(this.bfoo1, this.bfoo2);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)reply);
        reply = this.jedis.del(this.bfoo1, this.bfoo2);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)reply);
    }

    @Test
    public void type() {
        this.jedis.set("foo", "bar");
        String status = this.jedis.type("foo");
        AllKindOfValuesCommandsTest.assertEquals((Object)"string", (Object)status);
        this.jedis.set(this.bfoo, this.bbar);
        status = this.jedis.type(this.bfoo);
        AllKindOfValuesCommandsTest.assertEquals((Object)"string", (Object)status);
    }

    @Test
    public void keys() {
        this.jedis.set("foo", "bar");
        this.jedis.set("foobar", "bar");
        Set<String> keys = this.jedis.keys("foo*");
        HashSet<String> expected = new HashSet<String>();
        expected.add("foo");
        expected.add("foobar");
        AllKindOfValuesCommandsTest.assertEquals(expected, keys);
        expected = new HashSet();
        keys = this.jedis.keys("bar*");
        AllKindOfValuesCommandsTest.assertEquals(expected, keys);
        this.jedis.set(this.bfoo, this.bbar);
        this.jedis.set(this.bfoobar, this.bbar);
        Set<byte[]> bkeys = this.jedis.keys(this.bfoostar);
        AllKindOfValuesCommandsTest.assertEquals((long)2L, (long)bkeys.size());
        AllKindOfValuesCommandsTest.assertTrue((boolean)this.setContains(bkeys, this.bfoo));
        AllKindOfValuesCommandsTest.assertTrue((boolean)this.setContains(bkeys, this.bfoobar));
        bkeys = this.jedis.keys(this.bbarstar);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)bkeys.size());
    }

    @Test
    public void randomKey() {
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)this.jedis.randomKey());
        this.jedis.set("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((Object)"foo", (Object)this.jedis.randomKey());
        this.jedis.set("bar", "foo");
        String randomkey = this.jedis.randomKey();
        AllKindOfValuesCommandsTest.assertTrue((randomkey.equals("foo") || randomkey.equals("bar") ? 1 : 0) != 0);
        this.jedis.del("foo");
        this.jedis.del("bar");
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)this.jedis.randomKey());
        this.jedis.set(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])this.bfoo, (byte[])this.jedis.randomBinaryKey());
        this.jedis.set(this.bbar, this.bfoo);
        byte[] randomBkey = this.jedis.randomBinaryKey();
        AllKindOfValuesCommandsTest.assertTrue((Arrays.equals(randomBkey, this.bfoo) || Arrays.equals(randomBkey, this.bbar) ? 1 : 0) != 0);
    }

    @Test
    public void rename() {
        this.jedis.set("foo", "bar");
        String status = this.jedis.rename("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        String value = this.jedis.get("foo");
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)value);
        value = this.jedis.get("bar");
        AllKindOfValuesCommandsTest.assertEquals((Object)"bar", (Object)value);
        this.jedis.set(this.bfoo, this.bbar);
        String bstatus = this.jedis.rename(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        byte[] bvalue = this.jedis.get(this.bfoo);
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)bvalue);
        bvalue = this.jedis.get(this.bbar);
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])bvalue);
    }

    @Test
    public void renameOldAndNewAreTheSame() {
        this.jedis.set("foo", "bar");
        this.jedis.rename("foo", "foo");
        this.jedis.set(this.bfoo, this.bbar);
        this.jedis.rename(this.bfoo, this.bfoo);
    }

    @Test
    public void renamenx() {
        this.jedis.set("foo", "bar");
        long status = this.jedis.renamenx("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        this.jedis.set("foo", "bar");
        status = this.jedis.renamenx("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.set(this.bfoo, this.bbar);
        long bstatus = this.jedis.renamenx(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)bstatus);
        this.jedis.set(this.bfoo, this.bbar);
        bstatus = this.jedis.renamenx(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)bstatus);
    }

    @Test
    public void dbSize() {
        long size = this.jedis.dbSize();
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)size);
        this.jedis.set("foo", "bar");
        size = this.jedis.dbSize();
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)size);
        this.jedis.set(this.bfoo, this.bbar);
        size = this.jedis.dbSize();
        AllKindOfValuesCommandsTest.assertEquals((long)2L, (long)size);
    }

    @Test
    public void expire() {
        long status = this.jedis.expire("foo", 20);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.set("foo", "bar");
        status = this.jedis.expire("foo", 20);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        long bstatus = this.jedis.expire(this.bfoo, 20);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)bstatus);
        this.jedis.set(this.bfoo, this.bbar);
        bstatus = this.jedis.expire(this.bfoo, 20);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)bstatus);
    }

    @Test
    public void expireAt() {
        long unixTime = System.currentTimeMillis() / 1000L + 20L;
        long status = this.jedis.expireAt("foo", unixTime);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.set("foo", "bar");
        unixTime = System.currentTimeMillis() / 1000L + 20L;
        status = this.jedis.expireAt("foo", unixTime);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        long bstatus = this.jedis.expireAt(this.bfoo, unixTime);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)bstatus);
        this.jedis.set(this.bfoo, this.bbar);
        unixTime = System.currentTimeMillis() / 1000L + 20L;
        bstatus = this.jedis.expireAt(this.bfoo, unixTime);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)bstatus);
    }

    @Test
    public void ttl() {
        long ttl = this.jedis.ttl("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)-2L, (long)ttl);
        this.jedis.set("foo", "bar");
        ttl = this.jedis.ttl("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)-1L, (long)ttl);
        this.jedis.expire("foo", 20);
        ttl = this.jedis.ttl("foo");
        AllKindOfValuesCommandsTest.assertTrue((ttl >= 0L && ttl <= 20L ? 1 : 0) != 0);
        long bttl = this.jedis.ttl(this.bfoo);
        AllKindOfValuesCommandsTest.assertEquals((long)-2L, (long)bttl);
        this.jedis.set(this.bfoo, this.bbar);
        bttl = this.jedis.ttl(this.bfoo);
        AllKindOfValuesCommandsTest.assertEquals((long)-1L, (long)bttl);
        this.jedis.expire(this.bfoo, 20);
        bttl = this.jedis.ttl(this.bfoo);
        AllKindOfValuesCommandsTest.assertTrue((bttl >= 0L && bttl <= 20L ? 1 : 0) != 0);
    }

    @Test
    public void select() {
        this.jedis.set("foo", "bar");
        String status = this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)this.jedis.get("foo"));
        status = this.jedis.select(0);
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        AllKindOfValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        this.jedis.set(this.bfoo, this.bbar);
        String bstatus = this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)this.jedis.get(this.bfoo));
        bstatus = this.jedis.select(0);
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])this.jedis.get(this.bfoo));
    }

    @Test
    public void getDB() {
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.getDB());
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.getDB());
    }

    @Test
    public void move() {
        long status = this.jedis.move("foo", 1);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.set("foo", "bar");
        status = this.jedis.move("foo", 1);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)this.jedis.get("foo"));
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        this.jedis.select(0);
        long bstatus = this.jedis.move(this.bfoo, 1);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)bstatus);
        this.jedis.set(this.bfoo, this.bbar);
        bstatus = this.jedis.move(this.bfoo, 1);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)bstatus);
        AllKindOfValuesCommandsTest.assertEquals(null, (Object)this.jedis.get(this.bfoo));
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])this.bbar, (byte[])this.jedis.get(this.bfoo));
    }

    @Test
    public void flushDB() {
        this.jedis.set("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.dbSize().intValue());
        this.jedis.set("bar", "foo");
        this.jedis.move("bar", 1);
        String status = this.jedis.flushDB();
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.dbSize().intValue());
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.dbSize().intValue());
        this.jedis.del("bar");
        this.jedis.select(0);
        this.jedis.set(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.dbSize().intValue());
        this.jedis.set(this.bbar, this.bfoo);
        this.jedis.move(this.bbar, 1);
        String bstatus = this.jedis.flushDB();
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.dbSize().intValue());
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.dbSize().intValue());
    }

    @Test
    public void flushAll() {
        this.jedis.set("foo", "bar");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.dbSize().intValue());
        this.jedis.set("bar", "foo");
        this.jedis.move("bar", 1);
        String status = this.jedis.flushAll();
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.dbSize().intValue());
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.dbSize().intValue());
        this.jedis.select(0);
        this.jedis.set(this.bfoo, this.bbar);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)this.jedis.dbSize().intValue());
        this.jedis.set(this.bbar, this.bfoo);
        this.jedis.move(this.bbar, 1);
        String bstatus = this.jedis.flushAll();
        AllKindOfValuesCommandsTest.assertEquals((Object)"OK", (Object)bstatus);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.dbSize().intValue());
        this.jedis.select(1);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)this.jedis.dbSize().intValue());
    }

    @Test
    public void persist() {
        this.jedis.setex("foo", 3600, "bar");
        AllKindOfValuesCommandsTest.assertTrue((this.jedis.ttl("foo") > 0L ? 1 : 0) != 0);
        long status = this.jedis.persist("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        AllKindOfValuesCommandsTest.assertEquals((long)-1L, (long)this.jedis.ttl("foo").intValue());
        this.jedis.setex(this.bfoo, 3600, this.bbar);
        AllKindOfValuesCommandsTest.assertTrue((this.jedis.ttl(this.bfoo) > 0L ? 1 : 0) != 0);
        long bstatus = this.jedis.persist(this.bfoo);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)bstatus);
        AllKindOfValuesCommandsTest.assertEquals((long)-1L, (long)this.jedis.ttl(this.bfoo).intValue());
    }

    @Test
    public void echo() {
        String result = this.jedis.echo("hello world");
        AllKindOfValuesCommandsTest.assertEquals((Object)"hello world", (Object)result);
        byte[] bresult = this.jedis.echo(SafeEncoder.encode("hello world"));
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])SafeEncoder.encode("hello world"), (byte[])bresult);
    }

    @Test
    public void dumpAndRestore() {
        this.jedis.set("foo1", "bar1");
        byte[] sv = this.jedis.dump("foo1");
        this.jedis.restore("foo2", 0, sv);
        AllKindOfValuesCommandsTest.assertTrue((boolean)this.jedis.exists("foo2"));
    }

    @Test
    public void pexpire() {
        long status = this.jedis.pexpire("foo", 10000);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.set("foo1", "bar1");
        status = this.jedis.pexpire("foo1", 10000);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        this.jedis.set("foo2", "bar2");
        status = this.jedis.pexpire("foo2", 200000000000L);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
        long pttl = this.jedis.pttl("foo2");
        AllKindOfValuesCommandsTest.assertTrue((pttl > 100000000000L ? 1 : 0) != 0);
    }

    @Test
    public void pexpireAt() {
        long unixTime = System.currentTimeMillis() + 10000L;
        long status = this.jedis.pexpireAt("foo", unixTime);
        AllKindOfValuesCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.set("foo", "bar");
        unixTime = System.currentTimeMillis() + 10000L;
        status = this.jedis.pexpireAt("foo", unixTime);
        AllKindOfValuesCommandsTest.assertEquals((long)1L, (long)status);
    }

    @Test
    public void pttl() {
        long pttl = this.jedis.pttl("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)-2L, (long)pttl);
        this.jedis.set("foo", "bar");
        pttl = this.jedis.pttl("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)-1L, (long)pttl);
        this.jedis.pexpire("foo", 20000);
        pttl = this.jedis.pttl("foo");
        AllKindOfValuesCommandsTest.assertTrue((pttl >= 0L && pttl <= 20000L ? 1 : 0) != 0);
    }

    @Test
    public void psetex() {
        long pttl = this.jedis.pttl("foo");
        AllKindOfValuesCommandsTest.assertEquals((long)-2L, (long)pttl);
        String status = this.jedis.psetex("foo", 200000000000L, "bar");
        AllKindOfValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        pttl = this.jedis.pttl("foo");
        AllKindOfValuesCommandsTest.assertTrue((pttl > 100000000000L ? 1 : 0) != 0);
    }

    @Test
    public void scan() {
        this.jedis.set("b", "b");
        this.jedis.set("a", "a");
        ScanResult<String> result = this.jedis.scan(ScanParams.SCAN_POINTER_START);
        AllKindOfValuesCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        AllKindOfValuesCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        ScanResult<byte[]> bResult = this.jedis.scan(ScanParams.SCAN_POINTER_START_BINARY);
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        AllKindOfValuesCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void scanMatch() {
        ScanParams params = new ScanParams();
        params.match("a*");
        this.jedis.set("b", "b");
        this.jedis.set("a", "a");
        this.jedis.set("aa", "aa");
        ScanResult<String> result = this.jedis.scan(ScanParams.SCAN_POINTER_START, params);
        AllKindOfValuesCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        AllKindOfValuesCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.match(this.bfoostar);
        this.jedis.set(this.bfoo1, this.bbar);
        this.jedis.set(this.bfoo2, this.bbar);
        this.jedis.set(this.bfoo3, this.bbar);
        ScanResult<byte[]> bResult = this.jedis.scan(ScanParams.SCAN_POINTER_START_BINARY, params);
        AllKindOfValuesCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        AllKindOfValuesCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void scanCount() {
        ScanParams params = new ScanParams();
        params.count(2);
        int i = 0;
        while (i < 10) {
            this.jedis.set("a" + i, "a" + i);
            ++i;
        }
        ScanResult<String> result = this.jedis.scan(ScanParams.SCAN_POINTER_START, params);
        AllKindOfValuesCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.count(2);
        this.jedis.set(this.bfoo1, this.bbar);
        this.jedis.set(this.bfoo2, this.bbar);
        this.jedis.set(this.bfoo3, this.bbar);
        ScanResult<byte[]> bResult = this.jedis.scan(ScanParams.SCAN_POINTER_START_BINARY, params);
        AllKindOfValuesCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void setNxExAndGet() {
        String status = this.jedis.set("hello", "world", "NX", "EX", 2L);
        AllKindOfValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(status));
        String value = this.jedis.get("hello");
        AllKindOfValuesCommandsTest.assertEquals((Object)"world", (Object)value);
        this.jedis.set("hello", "bar", "NX", "EX", 2L);
        value = this.jedis.get("hello");
        AllKindOfValuesCommandsTest.assertEquals((Object)"world", (Object)value);
        long ttl = this.jedis.ttl("hello");
        AllKindOfValuesCommandsTest.assertTrue((ttl > 0L && ttl <= 2L ? 1 : 0) != 0);
        byte[] bworld = new byte[]{119, 111, 114, 108, 100};
        byte[] bhello = new byte[]{104, 101, 108, 108, 111};
        String bstatus = this.jedis.set(bworld, bhello, this.bnx, this.bex, 2L);
        AllKindOfValuesCommandsTest.assertTrue((boolean)Protocol.Keyword.OK.name().equalsIgnoreCase(bstatus));
        byte[] bvalue = this.jedis.get(bworld);
        AllKindOfValuesCommandsTest.assertTrue((boolean)Arrays.equals(bhello, bvalue));
        this.jedis.set(bworld, this.bbar, this.bnx, this.bex, 2L);
        bvalue = this.jedis.get(bworld);
        AllKindOfValuesCommandsTest.assertTrue((boolean)Arrays.equals(bhello, bvalue));
        long bttl = this.jedis.ttl(bworld);
        AllKindOfValuesCommandsTest.assertTrue((bttl > 0L && bttl <= 2L ? 1 : 0) != 0);
    }
}

