/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.collections;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SetFromListTest {
    private static Method method;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Class<?> clazz = Class.forName("redis.clients.jedis.BinaryJedis$SetFromList");
        method = clazz.getDeclaredMethod("of", List.class);
        method.setAccessible(true);
    }

    private <E> Set<E> setFromList(List<E> list) throws Exception {
        return (Set)method.invoke(null, list);
    }

    @Test
    public void setOperations() throws Exception {
        Set<String> cut = this.setFromList(new ArrayList());
        cut.add("A");
        cut.add("B");
        cut.add("A");
        Assert.assertEquals((long)2L, (long)cut.size());
        cut.remove("A");
        Assert.assertEquals((long)1L, (long)cut.size());
        cut.remove("C");
        Assert.assertEquals((long)1L, (long)cut.size());
        Assert.assertTrue((boolean)cut.contains("B"));
        Assert.assertFalse((boolean)cut.contains("A"));
        cut.add("C");
        cut.add("D");
        Assert.assertTrue((boolean)cut.containsAll(cut));
        cut.retainAll(Arrays.asList("C", "D"));
        Assert.assertEquals((long)2L, (long)cut.size());
        Assert.assertTrue((boolean)cut.contains("C"));
        Assert.assertTrue((boolean)cut.contains("D"));
        cut.removeAll(Arrays.asList("C"));
        Assert.assertEquals((long)1L, (long)cut.size());
        Assert.assertTrue((boolean)cut.contains("D"));
        cut.clear();
        Assert.assertTrue((boolean)cut.isEmpty());
    }

    @Test
    public void iteration() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        int i = 97;
        while (i <= 122) {
            list.add(String.valueOf((char)i));
            ++i;
        }
        Set cut = this.setFromList(list);
        int i2 = 0;
        for (String x : cut) {
            Assert.assertEquals(list.get(i2++), (Object)x);
        }
    }

    @Test
    public void equals() throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        int i = 97;
        while (i <= 122) {
            hashSet.add(String.valueOf((char)i));
            ++i;
        }
        Set cut = this.setFromList(new ArrayList(hashSet));
        Assert.assertTrue((boolean)hashSet.equals(cut));
        Assert.assertTrue((boolean)cut.equals(hashSet));
        Assert.assertFalse((boolean)cut.equals(null));
        Assert.assertFalse((boolean)cut.equals(new ArrayList()));
    }
}

