/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.benchmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Protocol;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;

public class ProtocolBenchmark {
    private static final int TOTAL_OPERATIONS = 500000;

    public static void main(String[] args) throws Exception, IOException {
        long ops;
        long elapsed;
        long total = 0L;
        int at = 0;
        while (at != 10) {
            elapsed = ProtocolBenchmark.measureInputMulti();
            ops = 1000000000L / TimeUnit.NANOSECONDS.toMillis(elapsed);
            if (at >= 5) {
                total += ops;
            }
            ++at;
        }
        System.out.println(String.valueOf(total / 5L) + " avg");
        total = 0L;
        at = 0;
        while (at != 10) {
            elapsed = ProtocolBenchmark.measureInputStatus();
            ops = 1000000000L / TimeUnit.NANOSECONDS.toMillis(elapsed);
            if (at >= 5) {
                total += ops;
            }
            ++at;
        }
        System.out.println(String.valueOf(total / 5L) + " avg");
        total = 0L;
        at = 0;
        while (at != 10) {
            elapsed = ProtocolBenchmark.measureCommand();
            ops = 1000000000L / TimeUnit.NANOSECONDS.toMillis(elapsed);
            if (at >= 5) {
                total += ops;
            }
            ++at;
        }
        System.out.println(String.valueOf(total / 5L) + " avg");
    }

    private static long measureInputMulti() throws Exception {
        long duration = 0L;
        ByteArrayInputStream is = new ByteArrayInputStream("*4\r\n$3\r\nfoo\r\n$13\r\nbarbarbarfooz\r\n$5\r\nHello\r\n$5\r\nWorld\r\n".getBytes());
        RedisInputStream in = new RedisInputStream(is);
        int n = 0;
        while (n <= 500000) {
            long start = System.nanoTime();
            Protocol.read(in);
            duration += System.nanoTime() - start;
            in.reset();
            ++n;
        }
        return duration;
    }

    private static long measureInputStatus() throws Exception {
        long duration = 0L;
        ByteArrayInputStream is = new ByteArrayInputStream("+OK\r\n".getBytes());
        RedisInputStream in = new RedisInputStream(is);
        int n = 0;
        while (n <= 500000) {
            long start = System.nanoTime();
            Protocol.read(in);
            duration += System.nanoTime() - start;
            in.reset();
            ++n;
        }
        return duration;
    }

    private static long measureCommand() throws Exception {
        long duration = 0L;
        byte[] KEY = "123456789".getBytes();
        byte[] VAL = "FooBar".getBytes();
        int n = 0;
        while (n <= 500000) {
            RedisOutputStream out = new RedisOutputStream(new ByteArrayOutputStream(8192));
            long start = System.nanoTime();
            Protocol.sendCommand(out, Protocol.Command.SET, (byte[][])new byte[][]{KEY, VAL});
            duration += System.nanoTime() - start;
            ++n;
        }
        return duration;
    }
}

