/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.benchmark;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.tests.HostAndPortUtil;

public class PoolBenchmark {
    private static HostAndPort hnp = HostAndPortUtil.getRedisServers().get(0);
    private static final int TOTAL_OPERATIONS = 100000;

    public static void main(String[] args) throws Exception {
        Jedis j = new Jedis(hnp.getHost(), hnp.getPort());
        j.connect();
        j.auth("foobared");
        j.flushAll();
        j.quit();
        j.disconnect();
        long t = System.currentTimeMillis();
        PoolBenchmark.withPool();
        long elapsed = System.currentTimeMillis() - t;
        System.out.println(String.valueOf(200000000L / elapsed) + " ops");
    }

    private static void withPool() throws Exception {
        JedisPool pool = new JedisPool(new GenericObjectPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared");
        ArrayList<Thread> tds = new ArrayList<Thread>();
        AtomicInteger ind = new AtomicInteger();
        int i = 0;
        while (i < 50) {
            Thread hj = new Thread(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while ((i = ind.getAndIncrement()) < 100000) {
                        try {
                            Jedis j = pool.getResource();
                            String key = "foo" + i;
                            j.set(key, key);
                            j.get(key);
                            pool.returnResource(j);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            tds.add(hj);
            hj.start();
            ++i;
        }
        for (Thread t : tds) {
            t.join();
        }
        pool.destroy();
    }
}

