/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.benchmark;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Calendar;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.tests.HostAndPortUtil;

public class PipelinedGetSetBenchmark {
    private static HostAndPort hnp = HostAndPortUtil.getRedisServers().get(0);
    private static final int TOTAL_OPERATIONS = 200000;

    public static void main(String[] args) throws UnknownHostException, IOException {
        Jedis jedis = new Jedis(hnp.getHost(), hnp.getPort());
        jedis.connect();
        jedis.auth("foobared");
        jedis.flushAll();
        long begin = Calendar.getInstance().getTimeInMillis();
        Pipeline p = jedis.pipelined();
        int n = 0;
        while (n <= 200000) {
            String key = "foo" + n;
            p.set(key, "bar" + n);
            p.get(key);
            ++n;
        }
        p.sync();
        long elapsed = Calendar.getInstance().getTimeInMillis() - begin;
        jedis.disconnect();
        System.out.println(String.valueOf(400000000L / elapsed) + " ops");
    }
}

