/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.benchmark;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Calendar;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.tests.HostAndPortUtil;

public class GetSetBenchmark {
    private static HostAndPort hnp = HostAndPortUtil.getRedisServers().get(0);
    private static final int TOTAL_OPERATIONS = 100000;

    public static void main(String[] args) throws UnknownHostException, IOException {
        Jedis jedis = new Jedis(hnp.getHost(), hnp.getPort());
        jedis.connect();
        jedis.auth("foobared");
        jedis.flushAll();
        long begin = Calendar.getInstance().getTimeInMillis();
        int n = 0;
        while (n <= 100000) {
            String key = "foo" + n;
            jedis.set(key, "bar" + n);
            jedis.get(key);
            ++n;
        }
        long elapsed = Calendar.getInstance().getTimeInMillis() - begin;
        jedis.disconnect();
        System.out.println(String.valueOf(200000000L / elapsed) + " ops");
    }
}

