/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.utils.ClientKillerUtil;
import redis.clients.util.Hashing;
import redis.clients.util.SafeEncoder;
import redis.clients.util.Sharded;

public class ShardedJedisTest
extends Assert {
    private static HostAndPort redis1 = HostAndPortUtil.getRedisServers().get(0);
    private static HostAndPort redis2 = HostAndPortUtil.getRedisServers().get(1);

    @Test
    public void testAvoidLeaksUponDisconnect() throws InterruptedException {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>(2);
        JedisShardInfo shard1 = new JedisShardInfo(redis1.getHost(), redis1.getPort());
        shard1.setPassword("foobared");
        shards.add(shard1);
        JedisShardInfo shard2 = new JedisShardInfo(redis2.getHost(), redis2.getPort());
        shard2.setPassword("foobared");
        shards.add(shard2);
        ShardedJedis shardedJedis = new ShardedJedis((List<JedisShardInfo>)shards);
        shardedJedis.set("a", "bar");
        JedisShardInfo ak = (JedisShardInfo)shardedJedis.getShardInfo("a");
        ShardedJedisTest.assertEquals((Object)shard2, (Object)ak);
        shardedJedis.set("b", "bar1");
        JedisShardInfo bk = (JedisShardInfo)shardedJedis.getShardInfo("b");
        ShardedJedisTest.assertEquals((Object)shard1, (Object)bk);
        Iterator it = shardedJedis.getAllShards().iterator();
        Jedis deadClient = (Jedis)it.next();
        deadClient.clientSetname("DEAD");
        ClientKillerUtil.killClient(deadClient, "DEAD");
        ShardedJedisTest.assertEquals((Object)true, (Object)deadClient.isConnected());
        ShardedJedisTest.assertEquals((Object)false, (Object)deadClient.getClient().getSocket().isClosed());
        ShardedJedisTest.assertEquals((Object)false, (Object)deadClient.getClient().isBroken());
        shardedJedis.disconnect();
        ShardedJedisTest.assertEquals((Object)false, (Object)deadClient.isConnected());
        ShardedJedisTest.assertEquals((Object)true, (Object)deadClient.getClient().getSocket().isClosed());
        ShardedJedisTest.assertEquals((Object)true, (Object)deadClient.getClient().isBroken());
        Jedis jedis2 = (Jedis)it.next();
        ShardedJedisTest.assertEquals((Object)false, (Object)jedis2.isConnected());
        ShardedJedisTest.assertEquals((Object)true, (Object)jedis2.getClient().getSocket().isClosed());
        ShardedJedisTest.assertEquals((Object)false, (Object)jedis2.getClient().isBroken());
    }

    private List<String> getKeysDifferentShard(ShardedJedis jedis) {
        ArrayList<String> ret = new ArrayList<String>();
        JedisShardInfo first = (JedisShardInfo)jedis.getShardInfo("a0");
        ret.add("a0");
        int i = 1;
        while (i < 100) {
            JedisShardInfo actual = (JedisShardInfo)jedis.getShardInfo("a" + i);
            if (actual != first) {
                ret.add("a" + i);
                break;
            }
            ++i;
        }
        return ret;
    }

    @Test
    public void checkSharding() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo(redis1.getHost(), redis1.getPort()));
        shards.add(new JedisShardInfo(redis2.getHost(), redis2.getPort()));
        ShardedJedis jedis = new ShardedJedis((List<JedisShardInfo>)shards);
        List<String> keys = this.getKeysDifferentShard(jedis);
        JedisShardInfo s1 = (JedisShardInfo)jedis.getShardInfo(keys.get(0));
        JedisShardInfo s2 = (JedisShardInfo)jedis.getShardInfo(keys.get(1));
        ShardedJedisTest.assertNotSame((Object)s1, (Object)s2);
    }

    @Test
    public void trySharding() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        JedisShardInfo si = new JedisShardInfo(redis1.getHost(), redis1.getPort());
        si.setPassword("foobared");
        shards.add(si);
        si = new JedisShardInfo(redis2.getHost(), redis2.getPort());
        si.setPassword("foobared");
        shards.add(si);
        ShardedJedis jedis = new ShardedJedis((List<JedisShardInfo>)shards);
        jedis.set("a", "bar");
        JedisShardInfo s1 = (JedisShardInfo)jedis.getShardInfo("a");
        jedis.set("b", "bar1");
        JedisShardInfo s2 = (JedisShardInfo)jedis.getShardInfo("b");
        jedis.disconnect();
        Jedis j = new Jedis(s1.getHost(), s1.getPort());
        j.auth("foobared");
        ShardedJedisTest.assertEquals((Object)"bar", (Object)j.get("a"));
        j.disconnect();
        j = new Jedis(s2.getHost(), s2.getPort());
        j.auth("foobared");
        ShardedJedisTest.assertEquals((Object)"bar1", (Object)j.get("b"));
        j.disconnect();
    }

    @Test
    public void tryShardingWithMurmure() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        JedisShardInfo si = new JedisShardInfo(redis1.getHost(), redis1.getPort());
        si.setPassword("foobared");
        shards.add(si);
        si = new JedisShardInfo(redis2.getHost(), redis2.getPort());
        si.setPassword("foobared");
        shards.add(si);
        ShardedJedis jedis = new ShardedJedis((List<JedisShardInfo>)shards, Hashing.MURMUR_HASH);
        jedis.set("a", "bar");
        JedisShardInfo s1 = (JedisShardInfo)jedis.getShardInfo("a");
        jedis.set("b", "bar1");
        JedisShardInfo s2 = (JedisShardInfo)jedis.getShardInfo("b");
        jedis.disconnect();
        Jedis j = new Jedis(s1.getHost(), s1.getPort());
        j.auth("foobared");
        ShardedJedisTest.assertEquals((Object)"bar", (Object)j.get("a"));
        j.disconnect();
        j = new Jedis(s2.getHost(), s2.getPort());
        j.auth("foobared");
        ShardedJedisTest.assertEquals((Object)"bar1", (Object)j.get("b"));
        j.disconnect();
    }

    @Test
    public void checkKeyTags() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo(redis1.getHost(), redis1.getPort()));
        shards.add(new JedisShardInfo(redis2.getHost(), redis2.getPort()));
        ShardedJedis jedis = new ShardedJedis((List<JedisShardInfo>)shards, ShardedJedis.DEFAULT_KEY_TAG_PATTERN);
        ShardedJedisTest.assertEquals((Object)jedis.getKeyTag("foo"), (Object)"foo");
        ShardedJedisTest.assertEquals((Object)jedis.getKeyTag("foo{bar}"), (Object)"bar");
        ShardedJedisTest.assertEquals((Object)jedis.getKeyTag("foo{bar}}"), (Object)"bar");
        ShardedJedisTest.assertEquals((Object)jedis.getKeyTag("{bar}foo"), (Object)"bar");
        ShardedJedisTest.assertEquals((Object)jedis.getKeyTag("f{bar}oo"), (Object)"bar");
        JedisShardInfo s1 = (JedisShardInfo)jedis.getShardInfo("abc{bar}");
        JedisShardInfo s2 = (JedisShardInfo)jedis.getShardInfo("foo{bar}");
        ShardedJedisTest.assertSame((Object)s1, (Object)s2);
        List<String> keys = this.getKeysDifferentShard(jedis);
        JedisShardInfo s3 = (JedisShardInfo)jedis.getShardInfo(keys.get(0));
        JedisShardInfo s4 = (JedisShardInfo)jedis.getShardInfo(keys.get(1));
        ShardedJedisTest.assertNotSame((Object)s3, (Object)s4);
        ShardedJedis jedis2 = new ShardedJedis((List<JedisShardInfo>)shards);
        ShardedJedisTest.assertEquals((Object)jedis2.getKeyTag("foo"), (Object)"foo");
        ShardedJedisTest.assertNotSame((Object)jedis2.getKeyTag("foo{bar}"), (Object)"bar");
        JedisShardInfo s5 = (JedisShardInfo)jedis2.getShardInfo(String.valueOf(keys.get(0)) + "{bar}");
        JedisShardInfo s6 = (JedisShardInfo)jedis2.getShardInfo(String.valueOf(keys.get(1)) + "{bar}");
        ShardedJedisTest.assertNotSame((Object)s5, (Object)s6);
    }

    @Test
    public void shardedPipeline() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo(redis1.getHost(), redis1.getPort()));
        shards.add(new JedisShardInfo(redis2.getHost(), redis2.getPort()));
        ((JedisShardInfo)shards.get(0)).setPassword("foobared");
        ((JedisShardInfo)shards.get(1)).setPassword("foobared");
        ShardedJedis jedis = new ShardedJedis((List<JedisShardInfo>)shards);
        List<String> keys = this.getKeysDifferentShard(jedis);
        jedis.set(keys.get(0), "a");
        jedis.set(keys.get(1), "b");
        ShardedJedisTest.assertNotSame(jedis.getShard(keys.get(0)), jedis.getShard(keys.get(1)));
        List<Object> results = jedis.pipelined(new ShardedJedisPipeline(){

            @Override
            public void execute() {
                this.get((String)keys.get(0));
                this.get((String)keys.get(1));
            }
        });
        ArrayList<byte[]> expected = new ArrayList<byte[]>(2);
        expected.add(SafeEncoder.encode("a"));
        expected.add(SafeEncoder.encode("b"));
        ShardedJedisTest.assertEquals((long)2L, (long)results.size());
        ShardedJedisTest.assertArrayEquals((byte[])SafeEncoder.encode("a"), (byte[])((byte[])results.get(0)));
        ShardedJedisTest.assertArrayEquals((byte[])SafeEncoder.encode("b"), (byte[])((byte[])results.get(1)));
    }

    @Test
    public void testMD5Sharding() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>(3);
        shards.add(new JedisShardInfo("localhost", 6379));
        shards.add(new JedisShardInfo("localhost", 6380));
        shards.add(new JedisShardInfo("localhost", 6381));
        Sharded sharded = new Sharded(shards, Hashing.MD5);
        int shard_6379 = 0;
        int shard_6380 = 0;
        int shard_6381 = 0;
        int i = 0;
        while (i < 1000) {
            JedisShardInfo jedisShardInfo = (JedisShardInfo)sharded.getShardInfo(Integer.toString(i));
            switch (jedisShardInfo.getPort()) {
                case 6379: {
                    ++shard_6379;
                    break;
                }
                case 6380: {
                    ++shard_6380;
                    break;
                }
                case 6381: {
                    ++shard_6381;
                    break;
                }
                default: {
                    ShardedJedisTest.fail((String)("Attempting to use a non-defined shard!!:" + jedisShardInfo));
                }
            }
            ++i;
        }
        ShardedJedisTest.assertTrue((shard_6379 > 300 && shard_6379 < 400 ? 1 : 0) != 0);
        ShardedJedisTest.assertTrue((shard_6380 > 300 && shard_6380 < 400 ? 1 : 0) != 0);
        ShardedJedisTest.assertTrue((shard_6381 > 300 && shard_6381 < 400 ? 1 : 0) != 0);
    }

    @Test
    public void testMurmurSharding() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>(3);
        shards.add(new JedisShardInfo("localhost", 6379));
        shards.add(new JedisShardInfo("localhost", 6380));
        shards.add(new JedisShardInfo("localhost", 6381));
        Sharded sharded = new Sharded(shards, Hashing.MURMUR_HASH);
        int shard_6379 = 0;
        int shard_6380 = 0;
        int shard_6381 = 0;
        int i = 0;
        while (i < 1000) {
            JedisShardInfo jedisShardInfo = (JedisShardInfo)sharded.getShardInfo(Integer.toString(i));
            switch (jedisShardInfo.getPort()) {
                case 6379: {
                    ++shard_6379;
                    break;
                }
                case 6380: {
                    ++shard_6380;
                    break;
                }
                case 6381: {
                    ++shard_6381;
                    break;
                }
                default: {
                    ShardedJedisTest.fail((String)("Attempting to use a non-defined shard!!:" + jedisShardInfo));
                }
            }
            ++i;
        }
        ShardedJedisTest.assertTrue((shard_6379 > 300 && shard_6379 < 400 ? 1 : 0) != 0);
        ShardedJedisTest.assertTrue((shard_6380 > 300 && shard_6380 < 400 ? 1 : 0) != 0);
        ShardedJedisTest.assertTrue((shard_6381 > 300 && shard_6381 < 400 ? 1 : 0) != 0);
    }

    @Test
    public void testMasterSlaveShardingConsistency() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>(3);
        shards.add(new JedisShardInfo("localhost", 6379));
        shards.add(new JedisShardInfo("localhost", 6380));
        shards.add(new JedisShardInfo("localhost", 6381));
        Sharded sharded = new Sharded(shards, Hashing.MURMUR_HASH);
        ArrayList<JedisShardInfo> otherShards = new ArrayList<JedisShardInfo>(3);
        otherShards.add(new JedisShardInfo("otherhost", 6379));
        otherShards.add(new JedisShardInfo("otherhost", 6380));
        otherShards.add(new JedisShardInfo("otherhost", 6381));
        Sharded sharded2 = new Sharded(otherShards, Hashing.MURMUR_HASH);
        int i = 0;
        while (i < 1000) {
            JedisShardInfo jedisShardInfo = (JedisShardInfo)sharded.getShardInfo(Integer.toString(i));
            JedisShardInfo jedisShardInfo2 = (JedisShardInfo)sharded2.getShardInfo(Integer.toString(i));
            ShardedJedisTest.assertEquals((long)shards.indexOf(jedisShardInfo), (long)otherShards.indexOf(jedisShardInfo2));
            ++i;
        }
    }

    @Test
    public void testMasterSlaveShardingConsistencyWithShardNaming() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>(3);
        shards.add(new JedisShardInfo("localhost", 6379, "HOST1:1234"));
        shards.add(new JedisShardInfo("localhost", 6380, "HOST2:1234"));
        shards.add(new JedisShardInfo("localhost", 6381, "HOST3:1234"));
        Sharded sharded = new Sharded(shards, Hashing.MURMUR_HASH);
        ArrayList<JedisShardInfo> otherShards = new ArrayList<JedisShardInfo>(3);
        otherShards.add(new JedisShardInfo("otherhost", 6379, "HOST2:1234"));
        otherShards.add(new JedisShardInfo("otherhost", 6380, "HOST3:1234"));
        otherShards.add(new JedisShardInfo("otherhost", 6381, "HOST1:1234"));
        Sharded sharded2 = new Sharded(otherShards, Hashing.MURMUR_HASH);
        int i = 0;
        while (i < 1000) {
            JedisShardInfo jedisShardInfo = (JedisShardInfo)sharded.getShardInfo(Integer.toString(i));
            JedisShardInfo jedisShardInfo2 = (JedisShardInfo)sharded2.getShardInfo(Integer.toString(i));
            ShardedJedisTest.assertEquals((Object)jedisShardInfo.getName(), (Object)jedisShardInfo2.getName());
            ++i;
        }
    }

    @Test
    public void checkCloseable() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo(redis1.getHost(), redis1.getPort()));
        shards.add(new JedisShardInfo(redis2.getHost(), redis2.getPort()));
        ((JedisShardInfo)shards.get(0)).setPassword("foobared");
        ((JedisShardInfo)shards.get(1)).setPassword("foobared");
        ShardedJedis jedisShard = new ShardedJedis((List<JedisShardInfo>)shards);
        try {
            jedisShard.set("shard_closeable", "true");
        }
        finally {
            jedisShard.close();
        }
        for (Jedis jedis : jedisShard.getAllShards()) {
            ShardedJedisTest.assertTrue((!jedis.isConnected() ? 1 : 0) != 0);
        }
    }
}

