/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Response;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.HostAndPortUtil;

public class ShardedJedisPipelineTest {
    private static HostAndPort redis1 = HostAndPortUtil.getRedisServers().get(0);
    private static HostAndPort redis2 = HostAndPortUtil.getRedisServers().get(1);
    private ShardedJedis jedis;

    @Before
    public void setUp() throws Exception {
        Jedis jedis = new Jedis(redis1.getHost(), redis1.getPort());
        jedis.auth("foobared");
        jedis.flushAll();
        jedis.disconnect();
        jedis = new Jedis(redis2.getHost(), redis2.getPort());
        jedis.auth("foobared");
        jedis.flushAll();
        jedis.disconnect();
        JedisShardInfo shardInfo1 = new JedisShardInfo(redis1.getHost(), redis1.getPort());
        JedisShardInfo shardInfo2 = new JedisShardInfo(redis2.getHost(), redis2.getPort());
        shardInfo1.setPassword("foobared");
        shardInfo2.setPassword("foobared");
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(shardInfo1);
        shards.add(shardInfo2);
        this.jedis = new ShardedJedis((List<JedisShardInfo>)shards);
    }

    @Test
    public void pipeline() throws UnsupportedEncodingException {
        ShardedJedisPipeline p = this.jedis.pipelined();
        p.set("foo", "bar");
        p.get("foo");
        List<Object> results = p.syncAndReturnAll();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"OK", (Object)results.get(0));
        Assert.assertEquals((Object)"bar", (Object)results.get(1));
    }

    @Test
    public void pipelineResponse() {
        this.jedis.set("string", "foo");
        this.jedis.lpush("list", "foo");
        this.jedis.hset("hash", "foo", "bar");
        this.jedis.zadd("zset", 1.0, "foo");
        this.jedis.sadd("set", "foo");
        ShardedJedisPipeline p = this.jedis.pipelined();
        Response<String> string = p.get("string");
        Response<Long> del = p.del("string");
        Response<String> emptyString = p.get("string");
        Response<String> list = p.lpop("list");
        Response<String> hash = p.hget("hash", "foo");
        Response<Set<String>> zset = p.zrange("zset", 0L, -1L);
        Response<String> set = p.spop("set");
        Response<Boolean> blist = p.exists("list");
        Response<Double> zincrby = p.zincrby("zset", 1.0, "foo");
        Response<Long> zcard = p.zcard("zset");
        p.lpush("list", "bar");
        Response<List<String>> lrange = p.lrange("list", 0L, -1L);
        Response<Map<String, String>> hgetAll = p.hgetAll("hash");
        p.sadd("set", "foo");
        Response<Set<String>> smembers = p.smembers("set");
        Response<Set<Tuple>> zrangeWithScores = p.zrangeWithScores("zset", 0L, -1L);
        p.sync();
        Assert.assertEquals((Object)"foo", (Object)string.get());
        Assert.assertEquals((Object)1L, (Object)del.get());
        Assert.assertNull((Object)emptyString.get());
        Assert.assertEquals((Object)"foo", (Object)list.get());
        Assert.assertEquals((Object)"bar", (Object)hash.get());
        Assert.assertEquals((Object)"foo", (Object)zset.get().iterator().next());
        Assert.assertEquals((Object)"foo", (Object)set.get());
        Assert.assertFalse((boolean)blist.get());
        Assert.assertEquals((Object)2.0, (Object)zincrby.get());
        Assert.assertEquals((Object)1L, (Object)zcard.get());
        Assert.assertEquals((long)1L, (long)lrange.get().size());
        Assert.assertNotNull((Object)hgetAll.get().get("foo"));
        Assert.assertEquals((long)1L, (long)smembers.get().size());
        Assert.assertEquals((long)1L, (long)zrangeWithScores.get().size());
    }

    @Test(expected=JedisDataException.class)
    public void pipelineResponseWithinPipeline() {
        this.jedis.set("string", "foo");
        ShardedJedisPipeline p = this.jedis.pipelined();
        Response<String> string = p.get("string");
        string.get();
        p.sync();
    }

    @Test
    public void canRetrieveUnsetKey() {
        ShardedJedisPipeline p = this.jedis.pipelined();
        Response<String> shouldNotExist = p.get(UUID.randomUUID().toString());
        p.sync();
        Assert.assertNull((Object)shouldNotExist.get());
    }

    @Test
    public void testSyncWithNoCommandQueued() {
        JedisShardInfo shardInfo1 = new JedisShardInfo(redis1.getHost(), redis1.getPort());
        JedisShardInfo shardInfo2 = new JedisShardInfo(redis2.getHost(), redis2.getPort());
        shardInfo1.setPassword("foobared");
        shardInfo2.setPassword("foobared");
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(shardInfo1);
        shards.add(shardInfo2);
        ShardedJedis jedis2 = new ShardedJedis((List<JedisShardInfo>)shards);
        ShardedJedisPipeline pipeline = jedis2.pipelined();
        pipeline.sync();
        jedis2.close();
        jedis2 = new ShardedJedis((List<JedisShardInfo>)shards);
        pipeline = jedis2.pipelined();
        List<Object> resp = pipeline.syncAndReturnAll();
        Assert.assertTrue((boolean)resp.isEmpty());
        jedis2.close();
    }
}

