/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.tests.FragmentedByteArrayInputStream;
import redis.clients.jedis.tests.JedisTestBase;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;
import redis.clients.util.SafeEncoder;

public class ProtocolTest
extends JedisTestBase {
    @Test
    public void buildACommand() throws IOException {
        int b;
        PipedInputStream pis = new PipedInputStream();
        BufferedInputStream bis = new BufferedInputStream(pis);
        PipedOutputStream pos = new PipedOutputStream(pis);
        RedisOutputStream ros = new RedisOutputStream(pos);
        Protocol.sendCommand(ros, Protocol.Command.GET, (byte[][])new byte[][]{"SOMEKEY".getBytes("UTF-8")});
        ros.flush();
        pos.close();
        String expectedCommand = "*2\r\n$3\r\nGET\r\n$7\r\nSOMEKEY\r\n";
        StringBuilder sb = new StringBuilder();
        while ((b = bis.read()) != -1) {
            sb.append((char)b);
        }
        ProtocolTest.assertEquals((Object)expectedCommand, (Object)sb.toString());
    }

    @Test(expected=IOException.class)
    public void writeOverflow() throws IOException {
        RedisOutputStream ros = new RedisOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new IOException("thrown exception");
            }
        });
        ros.write(new byte[8191]);
        try {
            ros.write((byte)42);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ros.write((byte)42);
    }

    @Test
    public void bulkReply() {
        ByteArrayInputStream is = new ByteArrayInputStream("$6\r\nfoobar\r\n".getBytes());
        byte[] response = (byte[])Protocol.read(new RedisInputStream(is));
        ProtocolTest.assertArrayEquals((byte[])SafeEncoder.encode("foobar"), (byte[])response);
    }

    @Test
    public void fragmentedBulkReply() {
        FragmentedByteArrayInputStream fis = new FragmentedByteArrayInputStream("$30\r\n012345678901234567890123456789\r\n".getBytes());
        byte[] response = (byte[])Protocol.read(new RedisInputStream(fis));
        ProtocolTest.assertArrayEquals((byte[])SafeEncoder.encode("012345678901234567890123456789"), (byte[])response);
    }

    @Test
    public void nullBulkReply() {
        ByteArrayInputStream is = new ByteArrayInputStream("$-1\r\n".getBytes());
        String response = (String)Protocol.read(new RedisInputStream(is));
        ProtocolTest.assertEquals(null, (Object)response);
    }

    @Test
    public void singleLineReply() {
        ByteArrayInputStream is = new ByteArrayInputStream("+OK\r\n".getBytes());
        byte[] response = (byte[])Protocol.read(new RedisInputStream(is));
        ProtocolTest.assertArrayEquals((byte[])SafeEncoder.encode("OK"), (byte[])response);
    }

    @Test
    public void integerReply() {
        ByteArrayInputStream is = new ByteArrayInputStream(":123\r\n".getBytes());
        long response = (Long)Protocol.read(new RedisInputStream(is));
        ProtocolTest.assertEquals((long)123L, (long)response);
    }

    @Test
    public void multiBulkReply() {
        ByteArrayInputStream is = new ByteArrayInputStream("*4\r\n$3\r\nfoo\r\n$3\r\nbar\r\n$5\r\nHello\r\n$5\r\nWorld\r\n".getBytes());
        List response = (List)Protocol.read(new RedisInputStream(is));
        ArrayList<byte[]> expected = new ArrayList<byte[]>();
        expected.add(SafeEncoder.encode("foo"));
        expected.add(SafeEncoder.encode("bar"));
        expected.add(SafeEncoder.encode("Hello"));
        expected.add(SafeEncoder.encode("World"));
        this.assertEquals(expected, response);
    }

    @Test
    public void nullMultiBulkReply() {
        ByteArrayInputStream is = new ByteArrayInputStream("*-1\r\n".getBytes());
        List response = (List)Protocol.read(new RedisInputStream(is));
        ProtocolTest.assertNull((Object)response);
    }
}

