/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import org.junit.Assert;
import org.junit.Test;
import redis.clients.util.KeyMergeUtil;
import redis.clients.util.SafeEncoder;

public class KeyMergeUtilTest {
    @Test
    public void testMergeBinaryKeys() throws Exception {
        byte[] key = SafeEncoder.encode("hello");
        byte[][] keys = new byte[][]{SafeEncoder.encode("world"), SafeEncoder.encode("jedis")};
        byte[][] mergedKeys = KeyMergeUtil.merge(key, keys);
        Assert.assertNotNull((Object)mergedKeys);
        Assert.assertEquals((long)3L, (long)mergedKeys.length);
        Assert.assertEquals((Object)key, (Object)mergedKeys[0]);
        Assert.assertEquals((Object)keys[0], (Object)mergedKeys[1]);
        Assert.assertEquals((Object)keys[1], (Object)mergedKeys[2]);
    }

    @Test
    public void testMergeStringKeys() throws Exception {
        String key = "hello";
        String[] keys = new String[]{"world", "jedis"};
        String[] mergedKeys = KeyMergeUtil.merge(key, keys);
        Assert.assertNotNull((Object)mergedKeys);
        Assert.assertEquals((long)3L, (long)mergedKeys.length);
        Assert.assertEquals((Object)key, (Object)mergedKeys[0]);
        Assert.assertEquals((Object)keys[0], (Object)mergedKeys[1]);
        Assert.assertEquals((Object)keys[1], (Object)mergedKeys[2]);
    }
}

