/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.junit.Test;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class JedisTest
extends JedisCommandTestBase {
    @Test
    public void useWithoutConnecting() {
        Jedis jedis = new Jedis("localhost");
        jedis.auth("foobared");
        jedis.dbSize();
    }

    @Test
    public void checkBinaryData() {
        byte[] bigdata = new byte[1777];
        int b = 0;
        while (b < bigdata.length) {
            bigdata[b] = (byte)((byte)b % 255);
            ++b;
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("data", SafeEncoder.encode(bigdata));
        String status = this.jedis.hmset("foo", hash);
        JedisTest.assertEquals((Object)"OK", (Object)status);
        JedisTest.assertEquals(hash, this.jedis.hgetAll("foo"));
    }

    @Test
    public void connectWithShardInfo() {
        JedisShardInfo shardInfo = new JedisShardInfo("localhost", 6379);
        shardInfo.setPassword("foobared");
        Jedis jedis = new Jedis(shardInfo);
        jedis.get("foo");
    }

    @Test(expected=JedisConnectionException.class)
    public void timeoutConnection() throws Exception {
        this.jedis = new Jedis("localhost", 6379, 15000);
        this.jedis.auth("foobared");
        this.jedis.configSet("timeout", "1");
        Thread.sleep(2000L);
        this.jedis.hmget("foobar", "foo");
    }

    @Test(expected=JedisConnectionException.class)
    public void timeoutConnectionWithURI() throws Exception {
        this.jedis = new Jedis(new URI("redis://:foobared@localhost:6380/2"), 15000);
        this.jedis.configSet("timeout", "1");
        Thread.sleep(2000L);
        this.jedis.hmget("foobar", "foo");
    }

    @Test(expected=JedisDataException.class)
    public void failWhenSendingNullValues() {
        this.jedis.set("foo", null);
    }

    @Test(expected=InvalidURIException.class)
    public void shouldThrowInvalidURIExceptionForInvalidURI() throws URISyntaxException {
        Jedis j = new Jedis(new URI("localhost:6380"));
        j.ping();
    }

    @Test
    public void shouldReconnectToSameDB() throws IOException {
        this.jedis.select(1);
        this.jedis.set("foo", "bar");
        this.jedis.getClient().getSocket().shutdownInput();
        this.jedis.getClient().getSocket().shutdownOutput();
        JedisTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
    }

    @Test
    public void startWithUrlString() {
        Jedis j = new Jedis("localhost", 6380);
        j.auth("foobared");
        j.select(2);
        j.set("foo", "bar");
        Jedis jedis = new Jedis("redis://:foobared@localhost:6380/2");
        JedisTest.assertEquals((Object)"PONG", (Object)jedis.ping());
        JedisTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
    }

    @Test
    public void startWithUrl() throws URISyntaxException {
        Jedis j = new Jedis("localhost", 6380);
        j.auth("foobared");
        j.select(2);
        j.set("foo", "bar");
        Jedis jedis = new Jedis(new URI("redis://:foobared@localhost:6380/2"));
        JedisTest.assertEquals((Object)"PONG", (Object)jedis.ping());
        JedisTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
    }

    @Test
    public void shouldNotUpdateDbIndexIfSelectFails() throws URISyntaxException {
        long currentDb = this.jedis.getDB();
        try {
            int invalidDb = -1;
            this.jedis.select(invalidDb);
            JedisTest.fail((String)"Should throw an exception if tried to select invalid db");
        }
        catch (JedisException e) {
            JedisTest.assertEquals((long)currentDb, (long)this.jedis.getDB().intValue());
        }
    }

    @Test
    public void allowUrlWithNoDBAndNoPassword() {
        Jedis jedis = new Jedis("redis://localhost:6380");
        jedis.auth("foobared");
        JedisTest.assertEquals((Object)jedis.getClient().getHost(), (Object)"localhost");
        JedisTest.assertEquals((long)jedis.getClient().getPort(), (long)6380L);
        JedisTest.assertEquals((Object)jedis.getDB(), (Object)0L);
        jedis = new Jedis("redis://localhost:6380/");
        jedis.auth("foobared");
        JedisTest.assertEquals((Object)jedis.getClient().getHost(), (Object)"localhost");
        JedisTest.assertEquals((long)jedis.getClient().getPort(), (long)6380L);
        JedisTest.assertEquals((Object)jedis.getDB(), (Object)0L);
    }

    @Test
    public void checkCloseable() {
        this.jedis.close();
        BinaryJedis bj = new BinaryJedis("localhost");
        bj.connect();
        bj.close();
    }
}

