/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.JedisTestBase;
import redis.clients.jedis.tests.utils.JedisSentinelTestUtil;

public class JedisSentinelTest
extends JedisTestBase {
    private static final String MASTER_NAME = "mymaster";
    private static final String MONITOR_MASTER_NAME = "mymastermonitor";
    private static final String REMOVE_MASTER_NAME = "mymasterremove";
    private static final String FAILOVER_MASTER_NAME = "mymasterfailover";
    private static final String MASTER_IP = "127.0.0.1";
    protected static HostAndPort master = HostAndPortUtil.getRedisServers().get(0);
    protected static HostAndPort slave = HostAndPortUtil.getRedisServers().get(4);
    protected static HostAndPort sentinel = HostAndPortUtil.getSentinelServers().get(0);
    protected static HostAndPort sentinelForFailover = HostAndPortUtil.getSentinelServers().get(2);
    protected static HostAndPort masterForFailover = HostAndPortUtil.getRedisServers().get(5);

    @Before
    public void setup() throws InterruptedException {
    }

    @After
    public void clear() throws InterruptedException {
        this.ensureRemoved(MONITOR_MASTER_NAME);
        this.ensureRemoved(REMOVE_MASTER_NAME);
    }

    @Test
    public void sentinel() {
        Jedis j = new Jedis(sentinel.getHost(), sentinel.getPort());
        try {
            List<Map<String, String>> masters = j.sentinelMasters();
            boolean inMasters = false;
            for (Map<String, String> master : masters) {
                if (!MASTER_NAME.equals(master.get("name"))) continue;
                inMasters = true;
            }
            JedisSentinelTest.assertTrue((boolean)inMasters);
            List<String> masterHostAndPort = j.sentinelGetMasterAddrByName(MASTER_NAME);
            HostAndPort masterFromSentinel = new HostAndPort(masterHostAndPort.get(0), Integer.parseInt(masterHostAndPort.get(1)));
            JedisSentinelTest.assertEquals((Object)master, (Object)masterFromSentinel);
            List<Map<String, String>> slaves = j.sentinelSlaves(MASTER_NAME);
            JedisSentinelTest.assertTrue((!slaves.isEmpty() ? 1 : 0) != 0);
            JedisSentinelTest.assertEquals((long)master.getPort(), (long)Integer.parseInt(slaves.get(0).get("master-port")));
            JedisSentinelTest.assertEquals((Object)1L, (Object)j.sentinelReset(MASTER_NAME));
            JedisSentinelTest.assertEquals((Object)0L, (Object)j.sentinelReset("woofmymaster"));
        }
        finally {
            j.close();
        }
    }

    @Test
    public void sentinelFailover() throws InterruptedException {
        Jedis j = new Jedis(sentinelForFailover.getHost(), sentinelForFailover.getPort());
        Jedis j2 = new Jedis(sentinelForFailover.getHost(), sentinelForFailover.getPort());
        try {
            List<String> masterHostAndPort = j.sentinelGetMasterAddrByName(FAILOVER_MASTER_NAME);
            HostAndPort currentMaster = new HostAndPort(masterHostAndPort.get(0), Integer.parseInt(masterHostAndPort.get(1)));
            JedisSentinelTestUtil.waitForNewPromotedMaster(FAILOVER_MASTER_NAME, j, j2);
            masterHostAndPort = j.sentinelGetMasterAddrByName(FAILOVER_MASTER_NAME);
            HostAndPort newMaster = new HostAndPort(masterHostAndPort.get(0), Integer.parseInt(masterHostAndPort.get(1)));
            JedisSentinelTest.assertNotEquals((Object)newMaster, (Object)currentMaster);
        }
        finally {
            j.close();
        }
    }

    @Test
    public void sentinelMonitor() {
        Jedis j = new Jedis(sentinel.getHost(), sentinel.getPort());
        try {
            String result = j.sentinelMonitor(MONITOR_MASTER_NAME, MASTER_IP, master.getPort(), 1);
            JedisSentinelTest.assertEquals((Object)"OK", (Object)result);
            try {
                j.sentinelMonitor(MONITOR_MASTER_NAME, MASTER_IP, master.getPort(), 1);
                JedisSentinelTest.fail();
            }
            catch (JedisDataException jedisDataException) {}
        }
        finally {
            j.close();
        }
    }

    @Test
    public void sentinelRemove() {
        Jedis j = new Jedis(sentinel.getHost(), sentinel.getPort());
        try {
            this.ensureMonitored(sentinel, REMOVE_MASTER_NAME, MASTER_IP, master.getPort(), 1);
            String result = j.sentinelRemove(REMOVE_MASTER_NAME);
            JedisSentinelTest.assertEquals((Object)"OK", (Object)result);
            try {
                result = j.sentinelRemove(REMOVE_MASTER_NAME);
                JedisSentinelTest.assertNotEquals((Object)"OK", (Object)result);
                JedisSentinelTest.fail();
            }
            catch (JedisDataException jedisDataException) {}
        }
        finally {
            j.close();
        }
    }

    @Test
    public void sentinelSet() {
        Jedis j = new Jedis(sentinel.getHost(), sentinel.getPort());
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("down-after-milliseconds", String.valueOf(1234));
            parameterMap.put("parallel-syncs", String.valueOf(3));
            parameterMap.put("quorum", String.valueOf(2));
            j.sentinelSet(MASTER_NAME, parameterMap);
            List<Map<String, String>> masters = j.sentinelMasters();
            for (Map<String, String> master : masters) {
                if (!master.get("name").equals(MASTER_NAME)) continue;
                JedisSentinelTest.assertEquals((long)1234L, (long)Integer.parseInt(master.get("down-after-milliseconds")));
                JedisSentinelTest.assertEquals((long)3L, (long)Integer.parseInt(master.get("parallel-syncs")));
                JedisSentinelTest.assertEquals((long)2L, (long)Integer.parseInt(master.get("quorum")));
            }
            parameterMap.put("quorum", String.valueOf(1));
            j.sentinelSet(MASTER_NAME, parameterMap);
        }
        finally {
            j.close();
        }
    }

    private void ensureMonitored(HostAndPort sentinel, String masterName, String ip, int port, int quorum) {
        Jedis j = new Jedis(sentinel.getHost(), sentinel.getPort());
        try {
            try {
                j.sentinelMonitor(masterName, ip, port, quorum);
            }
            catch (JedisDataException jedisDataException) {
                j.close();
            }
        }
        finally {
            j.close();
        }
    }

    private void ensureRemoved(String masterName) {
        Jedis j = new Jedis(sentinel.getHost(), sentinel.getPort());
        try {
            try {
                j.sentinelRemove(masterName);
            }
            catch (JedisDataException jedisDataException) {
                j.close();
            }
        }
        finally {
            j.close();
        }
    }
}

