/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.JedisTestBase;
import redis.clients.jedis.tests.utils.JedisSentinelTestUtil;

public class JedisSentinelPoolTest
extends JedisTestBase {
    private static final String MASTER_NAME = "mymaster";
    protected static HostAndPort master = HostAndPortUtil.getRedisServers().get(2);
    protected static HostAndPort slave1 = HostAndPortUtil.getRedisServers().get(3);
    protected static HostAndPort sentinel1 = HostAndPortUtil.getSentinelServers().get(1);
    protected static HostAndPort sentinel2 = HostAndPortUtil.getSentinelServers().get(3);
    protected static Jedis sentinelJedis1;
    protected static Jedis sentinelJedis2;
    protected Set<String> sentinels = new HashSet<String>();

    @Before
    public void setUp() throws Exception {
        this.sentinels.add(sentinel1.toString());
        this.sentinels.add(sentinel2.toString());
        sentinelJedis1 = new Jedis(sentinel1.getHost(), sentinel1.getPort());
        sentinelJedis2 = new Jedis(sentinel2.getHost(), sentinel2.getPort());
    }

    @Test(expected=JedisConnectionException.class)
    public void initializeWithNotAvailableSentinelsShouldThrowException() {
        HashSet<String> wrongSentinels = new HashSet<String>();
        wrongSentinels.add(new HostAndPort("localhost", 65432).toString());
        wrongSentinels.add(new HostAndPort("localhost", 65431).toString());
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, wrongSentinels);
        pool.destroy();
    }

    @Test(expected=JedisException.class)
    public void initializeWithNotMonitoredMasterNameShouldThrowException() {
        String wrongMasterName = "wrongMasterName";
        JedisSentinelPool pool = new JedisSentinelPool("wrongMasterName", this.sentinels);
        pool.destroy();
    }

    @Test
    public void checkCloseableConnections() throws Exception {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, this.sentinels, config, 1000, "foobared", 2);
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "bar");
        JedisSentinelPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
        pool.returnResource(jedis);
        pool.close();
        JedisSentinelPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void ensureSafeTwiceFailover() throws InterruptedException {
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, this.sentinels, new GenericObjectPoolConfig(), 2000, "foobared", 2);
        this.forceFailover(pool);
        Thread.sleep(100L);
        this.forceFailover(pool);
    }

    @Test
    public void returningBorrowedInstanceBeforeFailoverShouldNotAffectBorrowing() throws InterruptedException {
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, this.sentinels, new GenericObjectPoolConfig(), 2000, "foobared", 2);
        Jedis borrowed = pool.getResource();
        this.forceFailover(pool);
        Thread.sleep(1000L);
        borrowed.close();
        AtomicBoolean isBorrowed = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                pool.getResource();
                isBorrowed.set(true);
            }
        });
        t.start();
        t.join(5000L);
        JedisSentinelPoolTest.assertTrue((boolean)isBorrowed.get());
    }

    @Test
    public void returnResourceShouldResetState() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(false);
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, this.sentinels, config, 1000, "foobared", 2);
        Jedis jedis = pool.getResource();
        Jedis jedis2 = null;
        try {
            try {
                jedis.set("hello", "jedis");
                Transaction t = jedis.multi();
                t.set("hello", "world");
                pool.returnResource(jedis);
                jedis2 = pool.getResource();
                JedisSentinelPoolTest.assertTrue((jedis == jedis2 ? 1 : 0) != 0);
                JedisSentinelPoolTest.assertEquals((Object)"jedis", (Object)jedis2.get("hello"));
            }
            catch (JedisConnectionException e) {
                if (jedis2 != null) {
                    pool.returnBrokenResource(jedis2);
                    jedis2 = null;
                }
                if (jedis2 != null) {
                    jedis2.close();
                }
                pool.destroy();
            }
        }
        finally {
            if (jedis2 != null) {
                jedis2.close();
            }
            pool.destroy();
        }
    }

    @Test
    public void checkResourceIsCloseable() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(false);
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, this.sentinels, config, 1000, "foobared", 2);
        Jedis jedis = pool.getResource();
        try {
            jedis.set("hello", "jedis");
        }
        finally {
            jedis.close();
        }
        Jedis jedis2 = pool.getResource();
        try {
            JedisSentinelPoolTest.assertEquals((Object)jedis, (Object)jedis2);
        }
        finally {
            jedis2.close();
        }
    }

    @Test
    public void customClientName() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(false);
        JedisSentinelPool pool = new JedisSentinelPool(MASTER_NAME, this.sentinels, config, 1000, "foobared", 0, "my_shiny_client_name");
        Jedis jedis = pool.getResource();
        try {
            JedisSentinelPoolTest.assertEquals((Object)"my_shiny_client_name", (Object)jedis.clientGetname());
        }
        finally {
            jedis.close();
            pool.destroy();
        }
        JedisSentinelPoolTest.assertTrue((boolean)pool.isClosed());
    }

    private void forceFailover(JedisSentinelPool pool) throws InterruptedException {
        HostAndPort oldMaster = pool.getCurrentHostMaster();
        Jedis beforeFailoverJedis = pool.getResource();
        JedisSentinelPoolTest.assertEquals((Object)"PONG", (Object)beforeFailoverJedis.ping());
        this.waitForFailover(pool, oldMaster);
        Jedis afterFailoverJedis = pool.getResource();
        JedisSentinelPoolTest.assertEquals((Object)"PONG", (Object)afterFailoverJedis.ping());
        JedisSentinelPoolTest.assertEquals((Object)"foobared", (Object)afterFailoverJedis.configGet("requirepass").get(1));
        JedisSentinelPoolTest.assertEquals((long)2L, (long)afterFailoverJedis.getDB().intValue());
        beforeFailoverJedis.close();
        afterFailoverJedis.close();
    }

    private void waitForFailover(JedisSentinelPool pool, HostAndPort oldMaster) throws InterruptedException {
        HostAndPort newMaster = JedisSentinelTestUtil.waitForNewPromotedMaster(MASTER_NAME, sentinelJedis1, sentinelJedis2);
        this.waitForJedisSentinelPoolRecognizeNewMaster(pool, newMaster);
    }

    private void waitForJedisSentinelPoolRecognizeNewMaster(JedisSentinelPool pool, HostAndPort newMaster) throws InterruptedException {
        HostAndPort currentHostMaster;
        while (!newMaster.equals(currentHostMaster = pool.getCurrentHostMaster())) {
            System.out.println("JedisSentinelPool's master is not yet changed, sleep...");
            Thread.sleep(100L);
        }
    }
}

