/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.tests.HostAndPortUtil;

public class JedisPoolTest
extends Assert {
    private static HostAndPort hnp = HostAndPortUtil.getRedisServers().get(0);

    @Test
    public void checkConnections() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000);
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "bar");
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
        pool.returnResource(jedis);
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void checkCloseableConnections() throws Exception {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000);
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "bar");
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
        pool.returnResource(jedis);
        pool.close();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void checkConnectionWithDefaultPort() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort());
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "bar");
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
        pool.returnResource(jedis);
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void checkJedisIsReusedWhenReturned() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort());
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "0");
        pool.returnResource(jedis);
        jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.incr("foo");
        pool.returnResource(jedis);
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void checkPoolRepairedWhenJedisIsBroken() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort());
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.quit();
        pool.returnBrokenResource(jedis);
        jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.incr("foo");
        pool.returnResource(jedis);
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test(expected=JedisException.class)
    public void checkPoolOverflow() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(false);
        JedisPool pool = new JedisPool(config, hnp.getHost(), hnp.getPort());
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "0");
        Jedis newJedis = pool.getResource();
        newJedis.auth("foobared");
        newJedis.incr("foo");
    }

    @Test
    public void securePool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setTestOnBorrow(true);
        JedisPool pool = new JedisPool(config, hnp.getHost(), hnp.getPort(), 2000, "foobared");
        Jedis jedis = pool.getResource();
        jedis.set("foo", "bar");
        pool.returnResource(jedis);
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void nonDefaultDatabase() {
        JedisPool pool0 = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared");
        Jedis jedis0 = pool0.getResource();
        jedis0.set("foo", "bar");
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis0.get("foo"));
        pool0.returnResource(jedis0);
        pool0.destroy();
        JedisPoolTest.assertTrue((boolean)pool0.isClosed());
        JedisPool pool1 = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared", 1);
        Jedis jedis1 = pool1.getResource();
        JedisPoolTest.assertNull((Object)jedis1.get("foo"));
        pool1.returnResource(jedis1);
        pool1.destroy();
        JedisPoolTest.assertTrue((boolean)pool1.isClosed());
    }

    @Test
    public void startWithUrlString() {
        Jedis j = new Jedis("localhost", 6380);
        j.auth("foobared");
        j.select(2);
        j.set("foo", "bar");
        JedisPool pool = new JedisPool("redis://:foobared@localhost:6380/2");
        Jedis jedis = pool.getResource();
        JedisPoolTest.assertEquals((Object)"PONG", (Object)jedis.ping());
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
    }

    @Test
    public void startWithUrl() throws URISyntaxException {
        Jedis j = new Jedis("localhost", 6380);
        j.auth("foobared");
        j.select(2);
        j.set("foo", "bar");
        JedisPool pool = new JedisPool(new URI("redis://:foobared@localhost:6380/2"));
        Jedis jedis = pool.getResource();
        JedisPoolTest.assertEquals((Object)"PONG", (Object)jedis.ping());
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
    }

    @Test(expected=InvalidURIException.class)
    public void shouldThrowInvalidURIExceptionForInvalidURI() throws URISyntaxException {
        JedisPool pool = new JedisPool(new URI("localhost:6380"));
    }

    @Test
    public void allowUrlWithNoDBAndNoPassword() throws URISyntaxException {
        new JedisPool("redis://localhost:6380");
        new JedisPool(new URI("redis://localhost:6380"));
    }

    @Test
    public void selectDatabaseOnActivation() {
        JedisPool pool = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared");
        Jedis jedis0 = pool.getResource();
        JedisPoolTest.assertEquals((long)0L, (long)jedis0.getDB());
        jedis0.select(1);
        JedisPoolTest.assertEquals((long)1L, (long)jedis0.getDB());
        pool.returnResource(jedis0);
        Jedis jedis1 = pool.getResource();
        JedisPoolTest.assertTrue((String)"Jedis instance was not reused", (jedis1 == jedis0 ? 1 : 0) != 0);
        JedisPoolTest.assertEquals((long)0L, (long)jedis1.getDB());
        pool.returnResource(jedis1);
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void customClientName() {
        JedisPool pool0 = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared", 0, "my_shiny_client_name");
        Jedis jedis = pool0.getResource();
        JedisPoolTest.assertEquals((Object)"my_shiny_client_name", (Object)jedis.clientGetname());
        pool0.returnResource(jedis);
        pool0.destroy();
        JedisPoolTest.assertTrue((boolean)pool0.isClosed());
    }

    @Test
    public void returnResourceDestroysResourceOnException() {
        AtomicInteger destroyed = new AtomicInteger(0);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        JedisPool pool = new JedisPool(config, hnp.getHost(), hnp.getPort(), 2000, "foobared");
        class CrashingJedisPooledObjectFactory
        implements PooledObjectFactory<Jedis> {
            private final /* synthetic */ AtomicInteger val$destroyed;

            CrashingJedisPooledObjectFactory(AtomicInteger atomicInteger) {
                this.val$destroyed = atomicInteger;
            }

            @Override
            public PooledObject<Jedis> makeObject() throws Exception {
                class CrashingJedis
                extends Jedis {
                    CrashingJedis() {
                    }

                    @Override
                    public void resetState() {
                        throw new RuntimeException();
                    }
                }
                return new DefaultPooledObject<Jedis>(new CrashingJedis());
            }

            @Override
            public void destroyObject(PooledObject<Jedis> p) throws Exception {
                this.val$destroyed.incrementAndGet();
            }

            @Override
            public boolean validateObject(PooledObject<Jedis> p) {
                return true;
            }

            @Override
            public void activateObject(PooledObject<Jedis> p) throws Exception {
            }

            @Override
            public void passivateObject(PooledObject<Jedis> p) throws Exception {
            }
        }
        pool.initPool(config, new CrashingJedisPooledObjectFactory(destroyed));
        Jedis crashingJedis = pool.getResource();
        try {
            pool.returnResource(crashingJedis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JedisPoolTest.assertEquals((long)destroyed.get(), (long)1L);
    }

    @Test
    public void returnResourceShouldResetState() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(false);
        JedisPool pool = new JedisPool(config, hnp.getHost(), hnp.getPort(), 2000, "foobared");
        Jedis jedis = pool.getResource();
        try {
            jedis.set("hello", "jedis");
            Transaction t = jedis.multi();
            t.set("hello", "world");
        }
        finally {
            jedis.close();
        }
        Jedis jedis2 = pool.getResource();
        try {
            JedisPoolTest.assertTrue((jedis == jedis2 ? 1 : 0) != 0);
            JedisPoolTest.assertEquals((Object)"jedis", (Object)jedis2.get("hello"));
        }
        finally {
            jedis2.close();
        }
        pool.destroy();
        JedisPoolTest.assertTrue((boolean)pool.isClosed());
    }

    @Test
    public void checkResourceIsCloseable() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(1);
        config.setBlockWhenExhausted(false);
        JedisPool pool = new JedisPool(config, hnp.getHost(), hnp.getPort(), 2000, "foobared");
        Jedis jedis = pool.getResource();
        try {
            jedis.set("hello", "jedis");
        }
        finally {
            jedis.close();
        }
        Jedis jedis2 = pool.getResource();
        try {
            JedisPoolTest.assertEquals((Object)jedis, (Object)jedis2);
        }
        finally {
            jedis2.close();
        }
    }

    @Test
    public void returnNullObjectShouldNotFail() {
        JedisPool pool = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared", 0, "my_shiny_client_name");
        pool.returnBrokenResource(null);
        pool.returnResource(null);
        pool.returnResourceObject(null);
    }

    @Test
    public void getNumActiveIsNegativeWhenPoolIsClosed() {
        JedisPool pool = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "foobared", 0, "my_shiny_client_name");
        pool.destroy();
        JedisPoolTest.assertTrue((pool.getNumActive() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void getNumActiveReturnsTheCorrectNumber() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000);
        Jedis jedis = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "bar");
        JedisPoolTest.assertEquals((Object)"bar", (Object)jedis.get("foo"));
        JedisPoolTest.assertEquals((long)1L, (long)pool.getNumActive());
        Jedis jedis2 = pool.getResource();
        jedis.auth("foobared");
        jedis.set("foo", "bar");
        JedisPoolTest.assertEquals((long)2L, (long)pool.getNumActive());
        pool.returnResource(jedis);
        JedisPoolTest.assertEquals((long)1L, (long)pool.getNumActive());
        pool.returnResource(jedis2);
        JedisPoolTest.assertEquals((long)0L, (long)pool.getNumActive());
        pool.destroy();
    }

    @Test
    public void testAddObject() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000);
        pool.addObjects(1);
        JedisPoolTest.assertEquals((long)pool.getNumIdle(), (long)1L);
        pool.destroy();
    }

    @Test
    public void testCloseConnectionOnMakeObject() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setTestOnBorrow(true);
        JedisPool pool = new JedisPool(new JedisPoolConfig(), hnp.getHost(), hnp.getPort(), 2000, "wrong pass");
        Jedis jedis = new Jedis("redis://:foobared@localhost:6379/");
        int currentClientCount = this.getClientCount(jedis.clientList());
        try {
            pool.getResource();
            JedisPoolTest.fail((String)"Should throw exception as password is incorrect.");
        }
        catch (Exception e) {
            JedisPoolTest.assertEquals((long)currentClientCount, (long)this.getClientCount(jedis.clientList()));
        }
    }

    private int getClientCount(String clientList) {
        return clientList.split("\n").length;
    }
}

