/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterMaxRedirectionsException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.tests.HostAndPortUtil;
import redis.clients.jedis.tests.utils.ClientKillerUtil;
import redis.clients.jedis.tests.utils.JedisClusterTestUtil;
import redis.clients.util.JedisClusterCRC16;

public class JedisClusterTest
extends Assert {
    private static Jedis node1;
    private static Jedis node2;
    private static Jedis node3;
    private static Jedis node4;
    private static Jedis nodeSlave2;
    private String localHost = "127.0.0.1";
    private HostAndPort nodeInfo1 = HostAndPortUtil.getClusterServers().get(0);
    private HostAndPort nodeInfo2 = HostAndPortUtil.getClusterServers().get(1);
    private HostAndPort nodeInfo3 = HostAndPortUtil.getClusterServers().get(2);
    private HostAndPort nodeInfo4 = HostAndPortUtil.getClusterServers().get(3);
    private HostAndPort nodeInfoSlave2 = HostAndPortUtil.getClusterServers().get(4);
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @Before
    public void setUp() throws InterruptedException {
        node1 = new Jedis(this.nodeInfo1.getHost(), this.nodeInfo1.getPort());
        node1.connect();
        node1.flushAll();
        node2 = new Jedis(this.nodeInfo2.getHost(), this.nodeInfo2.getPort());
        node2.connect();
        node2.flushAll();
        node3 = new Jedis(this.nodeInfo3.getHost(), this.nodeInfo3.getPort());
        node3.connect();
        node3.flushAll();
        node4 = new Jedis(this.nodeInfo4.getHost(), this.nodeInfo4.getPort());
        node4.connect();
        node4.flushAll();
        nodeSlave2 = new Jedis(this.nodeInfoSlave2.getHost(), this.nodeInfoSlave2.getPort());
        nodeSlave2.connect();
        nodeSlave2.flushAll();
        node1.clusterMeet(this.localHost, this.nodeInfo2.getPort());
        node1.clusterMeet(this.localHost, this.nodeInfo3.getPort());
        int slotsPerNode = 5461;
        int[] node1Slots = new int[slotsPerNode];
        int[] node2Slots = new int[slotsPerNode + 1];
        int[] node3Slots = new int[slotsPerNode];
        int i = 0;
        int slot1 = 0;
        int slot2 = 0;
        int slot3 = 0;
        while (i < 16384) {
            if (i < slotsPerNode) {
                node1Slots[slot1++] = i;
            } else if (i > slotsPerNode * 2) {
                node3Slots[slot3++] = i;
            } else {
                node2Slots[slot2++] = i;
            }
            ++i;
        }
        node1.clusterAddSlots(node1Slots);
        node2.clusterAddSlots(node2Slots);
        node3.clusterAddSlots(node3Slots);
        JedisClusterTestUtil.waitForClusterReady(node1, node2, node3);
    }

    @AfterClass
    public static void cleanUp() {
        node1.flushDB();
        node2.flushDB();
        node3.flushDB();
        node4.flushDB();
        node1.clusterReset(JedisCluster.Reset.SOFT);
        node2.clusterReset(JedisCluster.Reset.SOFT);
        node3.clusterReset(JedisCluster.Reset.SOFT);
        node4.clusterReset(JedisCluster.Reset.SOFT);
    }

    @After
    public void tearDown() throws InterruptedException {
        JedisClusterTest.cleanUp();
    }

    @Test(expected=JedisMovedDataException.class)
    public void testThrowMovedException() {
        node1.set("foo", "bar");
    }

    @Test
    public void testMovedExceptionParameters() {
        try {
            node1.set("foo", "bar");
        }
        catch (JedisMovedDataException jme) {
            JedisClusterTest.assertEquals((long)12182L, (long)jme.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort("127.0.0.1", 7381), (Object)jme.getTargetNode());
            return;
        }
        JedisClusterTest.fail();
    }

    @Test(expected=JedisAskDataException.class)
    public void testThrowAskException() {
        int keySlot = JedisClusterCRC16.getSlot("test");
        String node3Id = JedisClusterTestUtil.getNodeId(node3.clusterNodes());
        node2.clusterSetSlotMigrating(keySlot, node3Id);
        node2.get("test");
    }

    @Test
    public void testDiscoverNodesAutomatically() {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        JedisClusterTest.assertEquals((long)3L, (long)jc.getClusterNodes().size());
        JedisCluster jc2 = new JedisCluster(new HostAndPort("127.0.0.1", 7379));
        JedisClusterTest.assertEquals((long)3L, (long)jc2.getClusterNodes().size());
    }

    @Test
    public void testCalculateConnectionPerSlot() {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        jc.set("foo", "bar");
        jc.set("test", "test");
        JedisClusterTest.assertEquals((Object)"bar", (Object)node3.get("foo"));
        JedisClusterTest.assertEquals((Object)"test", (Object)node2.get("test"));
        JedisCluster jc2 = new JedisCluster(new HostAndPort("127.0.0.1", 7379));
        jc2.set("foo", "bar");
        jc2.set("test", "test");
        JedisClusterTest.assertEquals((Object)"bar", (Object)node3.get("foo"));
        JedisClusterTest.assertEquals((Object)"test", (Object)node2.get("test"));
    }

    @Test
    public void testReadonly() throws Exception {
        node1.clusterMeet(this.localHost, this.nodeInfoSlave2.getPort());
        JedisClusterTestUtil.waitForClusterReady(node1, node2, node3, nodeSlave2);
        String[] stringArray = node2.clusterNodes().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeInfo = stringArray[n2];
            if (nodeInfo.contains("myself")) {
                nodeSlave2.clusterReplicate(nodeInfo.split(" ")[0]);
                break;
            }
            ++n2;
        }
        try {
            nodeSlave2.get("test");
            JedisClusterTest.fail();
        }
        catch (JedisMovedDataException jedisMovedDataException) {
            // empty catch block
        }
        nodeSlave2.readonly();
        nodeSlave2.get("test");
        nodeSlave2.clusterReset(JedisCluster.Reset.SOFT);
        nodeSlave2.flushDB();
    }

    @Test
    public void testMigrate() {
        this.log.info("test migrate slot");
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(this.nodeInfo1);
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        String node3Id = JedisClusterTestUtil.getNodeId(node3.clusterNodes());
        String node2Id = JedisClusterTestUtil.getNodeId(node2.clusterNodes());
        node3.clusterSetSlotMigrating(15363, node2Id);
        node2.clusterSetSlotImporting(15363, node3Id);
        try {
            node2.set("e", "e");
        }
        catch (JedisMovedDataException jme) {
            JedisClusterTest.assertEquals((long)15363L, (long)jme.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo3.getPort()), (Object)jme.getTargetNode());
        }
        try {
            node3.set("e", "e");
        }
        catch (JedisAskDataException jae) {
            JedisClusterTest.assertEquals((long)15363L, (long)jae.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo2.getPort()), (Object)jae.getTargetNode());
        }
        jc.set("e", "e");
        try {
            node2.get("e");
        }
        catch (JedisMovedDataException jme) {
            JedisClusterTest.assertEquals((long)15363L, (long)jme.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo3.getPort()), (Object)jme.getTargetNode());
        }
        try {
            node3.get("e");
        }
        catch (JedisAskDataException jae) {
            JedisClusterTest.assertEquals((long)15363L, (long)jae.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo2.getPort()), (Object)jae.getTargetNode());
        }
        JedisClusterTest.assertEquals((Object)"e", (Object)jc.get("e"));
        node2.clusterSetSlotNode(15363, node2Id);
        node3.clusterSetSlotNode(15363, node2Id);
        JedisClusterTest.assertEquals((Object)"e", (Object)node2.get("e"));
    }

    @Test
    public void testMigrateToNewNode() throws InterruptedException {
        this.log.info("test migrate slot to new node");
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(this.nodeInfo1);
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        node4.clusterMeet(this.localHost, this.nodeInfo1.getPort());
        String node3Id = JedisClusterTestUtil.getNodeId(node3.clusterNodes());
        String node4Id = JedisClusterTestUtil.getNodeId(node4.clusterNodes());
        JedisClusterTestUtil.waitForClusterReady(node4);
        node3.clusterSetSlotMigrating(15363, node4Id);
        node4.clusterSetSlotImporting(15363, node3Id);
        try {
            node4.set("e", "e");
        }
        catch (JedisMovedDataException jme) {
            JedisClusterTest.assertEquals((long)15363L, (long)jme.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo3.getPort()), (Object)jme.getTargetNode());
        }
        try {
            node3.set("e", "e");
        }
        catch (JedisAskDataException jae) {
            JedisClusterTest.assertEquals((long)15363L, (long)jae.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo4.getPort()), (Object)jae.getTargetNode());
        }
        jc.set("e", "e");
        try {
            node4.get("e");
        }
        catch (JedisMovedDataException jme) {
            JedisClusterTest.assertEquals((long)15363L, (long)jme.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo3.getPort()), (Object)jme.getTargetNode());
        }
        try {
            node3.get("e");
        }
        catch (JedisAskDataException jae) {
            JedisClusterTest.assertEquals((long)15363L, (long)jae.getSlot());
            JedisClusterTest.assertEquals((Object)new HostAndPort(this.localHost, this.nodeInfo4.getPort()), (Object)jae.getTargetNode());
        }
        JedisClusterTest.assertEquals((Object)"e", (Object)jc.get("e"));
        node4.clusterSetSlotNode(15363, node4Id);
        node3.clusterSetSlotNode(15363, node4Id);
        JedisClusterTest.assertEquals((Object)"e", (Object)node4.get("e"));
    }

    @Test
    public void testRecalculateSlotsWhenMoved() throws InterruptedException {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        int slot51 = JedisClusterCRC16.getSlot("51");
        node2.clusterDelSlots(slot51);
        node3.clusterDelSlots(slot51);
        node3.clusterAddSlots(slot51);
        JedisClusterTestUtil.waitForClusterReady(node1, node2, node3);
        jc.set("51", "foo");
        JedisClusterTest.assertEquals((Object)"foo", (Object)jc.get("51"));
    }

    @Test
    public void testAskResponse() throws InterruptedException {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        int slot51 = JedisClusterCRC16.getSlot("51");
        node3.clusterSetSlotImporting(slot51, JedisClusterTestUtil.getNodeId(node2.clusterNodes()));
        node2.clusterSetSlotMigrating(slot51, JedisClusterTestUtil.getNodeId(node3.clusterNodes()));
        jc.set("51", "foo");
        JedisClusterTest.assertEquals((Object)"foo", (Object)jc.get("51"));
    }

    @Test(expected=JedisClusterMaxRedirectionsException.class)
    public void testRedisClusterMaxRedirections() {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        int slot51 = JedisClusterCRC16.getSlot("51");
        node2.clusterSetSlotMigrating(slot51, JedisClusterTestUtil.getNodeId(node3.clusterNodes()));
        jc.set("51", "foo");
    }

    @Test
    public void testRedisHashtag() {
        JedisClusterTest.assertEquals((long)JedisClusterCRC16.getSlot("{bar"), (long)JedisClusterCRC16.getSlot("foo{{bar}}zap"));
        JedisClusterTest.assertEquals((long)JedisClusterCRC16.getSlot("{user1000}.following"), (long)JedisClusterCRC16.getSlot("{user1000}.followers"));
        JedisClusterTest.assertNotEquals((long)JedisClusterCRC16.getSlot("foo{}{bar}"), (long)JedisClusterCRC16.getSlot("bar"));
        JedisClusterTest.assertEquals((long)JedisClusterCRC16.getSlot("foo{bar}{zap}"), (long)JedisClusterCRC16.getSlot("bar"));
    }

    @Test
    public void testClusterForgetNode() throws InterruptedException {
        node1.clusterMeet("127.0.0.1", this.nodeInfo4.getPort());
        String node7Id = JedisClusterTestUtil.getNodeId(node4.clusterNodes());
        JedisClusterTestUtil.assertNodeIsKnown(node3, node7Id, 1000);
        JedisClusterTestUtil.assertNodeIsKnown(node2, node7Id, 1000);
        JedisClusterTestUtil.assertNodeIsKnown(node1, node7Id, 1000);
        this.assertNodeHandshakeEnded(node3, 1000);
        this.assertNodeHandshakeEnded(node2, 1000);
        this.assertNodeHandshakeEnded(node1, 1000);
        JedisClusterTest.assertEquals((long)4L, (long)node1.clusterNodes().split("\n").length);
        JedisClusterTest.assertEquals((long)4L, (long)node2.clusterNodes().split("\n").length);
        JedisClusterTest.assertEquals((long)4L, (long)node3.clusterNodes().split("\n").length);
        node1.clusterForget(node7Id);
        node2.clusterForget(node7Id);
        node3.clusterForget(node7Id);
        JedisClusterTestUtil.assertNodeIsUnknown(node1, node7Id, 1000);
        JedisClusterTestUtil.assertNodeIsUnknown(node2, node7Id, 1000);
        JedisClusterTestUtil.assertNodeIsUnknown(node3, node7Id, 1000);
        JedisClusterTest.assertEquals((long)3L, (long)node1.clusterNodes().split("\n").length);
        JedisClusterTest.assertEquals((long)3L, (long)node2.clusterNodes().split("\n").length);
        JedisClusterTest.assertEquals((long)3L, (long)node3.clusterNodes().split("\n").length);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testClusterFlushSlots() {
        slotRange = JedisClusterTest.getNodeServingSlotRange(JedisClusterTest.node1.clusterNodes());
        JedisClusterTest.assertNotNull((Object)slotRange);
        try {
            JedisClusterTest.node1.clusterFlushSlots();
            JedisClusterTest.assertNull((Object)JedisClusterTest.getNodeServingSlotRange(JedisClusterTest.node1.clusterNodes()));
        }
        finally {
            rangeInfo = slotRange.split("-");
            lower = Integer.parseInt(rangeInfo[0]);
            upper = Integer.parseInt(rangeInfo[1]);
            node1Slots = new int[upper - lower + 1];
            i = 0;
            ** while (lower <= upper)
        }
lbl-1000:
        // 1 sources

        {
            node1Slots[i++] = lower++;
            continue;
        }
lbl17:
        // 1 sources

        JedisClusterTest.node1.clusterAddSlots(node1Slots);
    }

    @Test
    public void testClusterKeySlot() {
        JedisClusterTest.assertEquals((long)node1.clusterKeySlot("foo{bar}zap}").intValue(), (long)JedisClusterCRC16.getSlot("foo{bar}zap"));
        JedisClusterTest.assertEquals((long)node1.clusterKeySlot("{user1000}.following").intValue(), (long)JedisClusterCRC16.getSlot("{user1000}.following"));
    }

    @Test
    public void testClusterCountKeysInSlot() {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort(this.nodeInfo1.getHost(), this.nodeInfo1.getPort()));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        int index = 0;
        while (index < 5) {
            jc.set("foo{bar}" + index, "hello");
            ++index;
        }
        int slot = JedisClusterCRC16.getSlot("foo{bar}");
        JedisClusterTest.assertEquals((long)5L, (long)node1.clusterCountKeysInSlot(slot).intValue());
    }

    @Test
    public void testStableSlotWhenMigratingNodeOrImportingNodeIsNotSpecified() throws InterruptedException {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort(this.nodeInfo1.getHost(), this.nodeInfo1.getPort()));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        int slot51 = JedisClusterCRC16.getSlot("51");
        jc.set("51", "foo");
        node3.clusterSetSlotImporting(slot51, JedisClusterTestUtil.getNodeId(node2.clusterNodes()));
        JedisClusterTest.assertEquals((Object)"foo", (Object)jc.get("51"));
        node3.clusterSetSlotStable(slot51);
        JedisClusterTest.assertEquals((Object)"foo", (Object)jc.get("51"));
        node2.clusterSetSlotMigrating(slot51, JedisClusterTestUtil.getNodeId(node3.clusterNodes()));
        node2.clusterSetSlotStable(slot51);
        JedisClusterTest.assertEquals((Object)"foo", (Object)jc.get("51"));
    }

    @Test(expected=JedisException.class)
    public void testIfPoolConfigAppliesToClusterPools() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(0);
        config.setMaxWaitMillis(2000L);
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode, config);
        jc.set("52", "poolTestValue");
    }

    @Test
    public void testCloseable() throws IOException {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort(this.nodeInfo1.getHost(), this.nodeInfo1.getPort()));
        JedisCluster jc = null;
        try {
            jc = new JedisCluster(jedisClusterNode);
            jc.set("51", "foo");
        }
        finally {
            if (jc != null) {
                jc.close();
            }
        }
        for (JedisPool pool : jc.getClusterNodes().values()) {
            try {
                pool.getResource();
                JedisClusterTest.fail((String)"JedisCluster's internal pools should be already destroyed");
            }
            catch (JedisConnectionException jedisConnectionException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testJedisClusterTimeout() {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort(this.nodeInfo1.getHost(), this.nodeInfo1.getPort()));
        JedisCluster jc = new JedisCluster(jedisClusterNode, 4000);
        for (JedisPool pool : jc.getClusterNodes().values()) {
            Jedis jedis = pool.getResource();
            JedisClusterTest.assertEquals((long)jedis.getClient().getConnectionTimeout(), (long)4000L);
            JedisClusterTest.assertEquals((long)jedis.getClient().getSoTimeout(), (long)4000L);
            jedis.close();
        }
    }

    @Test
    public void testJedisClusterRunsWithMultithreaded() throws InterruptedException, ExecutionException, IOException {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisCluster jc = new JedisCluster(jedisClusterNode);
        jc.set("foo", "bar");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 100, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 50) {
            executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return jc.get("foo");
                }
            });
            ++i;
        }
        for (Future future : futures) {
            String value = (String)future.get();
            JedisClusterTest.assertEquals((Object)"bar", (Object)value);
        }
        jc.close();
    }

    @Test(timeout=2000L)
    public void testReturnConnectionOnJedisConnectionException() throws InterruptedException {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(1);
        JedisCluster jc = new JedisCluster(jedisClusterNode, (GenericObjectPoolConfig)config);
        Jedis j = jc.getClusterNodes().get("127.0.0.1:7380").getResource();
        ClientKillerUtil.tagClient(j, "DEAD");
        ClientKillerUtil.killClient(j, "DEAD");
        j.close();
        jc.get("test");
    }

    @Test(expected=JedisClusterMaxRedirectionsException.class, timeout=2000L)
    public void testReturnConnectionOnRedirection() {
        HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
        jedisClusterNode.add(new HostAndPort("127.0.0.1", 7379));
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(1);
        JedisCluster jc = new JedisCluster(jedisClusterNode, 0, 2, (GenericObjectPoolConfig)config);
        node3.clusterSetSlotMigrating(15363, JedisClusterTestUtil.getNodeId(node2.clusterNodes()));
        jc.get("e");
    }

    private static String getNodeServingSlotRange(String infoOutput) {
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains("myself")) {
                try {
                    return infoLine.split(" ")[8];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    private void assertNodeHandshakeEnded(Jedis node, int timeoutMs) {
        int sleepInterval = 100;
        int sleepTime = 0;
        while (sleepTime <= timeoutMs) {
            boolean isHandshaking = this.isAnyNodeHandshaking(node);
            if (!isHandshaking) {
                return;
            }
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sleepTime += sleepInterval;
        }
        throw new JedisException("Node handshaking is not ended");
    }

    private boolean isAnyNodeHandshaking(Jedis node) {
        String infoOutput = node.clusterNodes();
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains("handshake")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

