/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.HostAndPort;

public final class HostAndPortUtil {
    private static List<HostAndPort> redisHostAndPortList = new ArrayList<HostAndPort>();
    private static List<HostAndPort> sentinelHostAndPortList = new ArrayList<HostAndPort>();
    private static List<HostAndPort> clusterHostAndPortList = new ArrayList<HostAndPort>();

    static {
        redisHostAndPortList.add(new HostAndPort("localhost", 6379));
        redisHostAndPortList.add(new HostAndPort("localhost", 6380));
        redisHostAndPortList.add(new HostAndPort("localhost", 6381));
        redisHostAndPortList.add(new HostAndPort("localhost", 6382));
        redisHostAndPortList.add(new HostAndPort("localhost", 6383));
        redisHostAndPortList.add(new HostAndPort("localhost", 6384));
        redisHostAndPortList.add(new HostAndPort("localhost", 6385));
        sentinelHostAndPortList.add(new HostAndPort("localhost", 26379));
        sentinelHostAndPortList.add(new HostAndPort("localhost", 26380));
        sentinelHostAndPortList.add(new HostAndPort("localhost", 26381));
        sentinelHostAndPortList.add(new HostAndPort("localhost", 26382));
        clusterHostAndPortList.add(new HostAndPort("localhost", 7379));
        clusterHostAndPortList.add(new HostAndPort("localhost", 7380));
        clusterHostAndPortList.add(new HostAndPort("localhost", 7381));
        clusterHostAndPortList.add(new HostAndPort("localhost", 7382));
        clusterHostAndPortList.add(new HostAndPort("localhost", 7383));
        clusterHostAndPortList.add(new HostAndPort("localhost", 7384));
        String envRedisHosts = System.getProperty("redis-hosts");
        String envSentinelHosts = System.getProperty("sentinel-hosts");
        String envClusterHosts = System.getProperty("cluster-hosts");
        redisHostAndPortList = HostAndPortUtil.parseHosts(envRedisHosts, redisHostAndPortList);
        sentinelHostAndPortList = HostAndPortUtil.parseHosts(envSentinelHosts, sentinelHostAndPortList);
        clusterHostAndPortList = HostAndPortUtil.parseHosts(envClusterHosts, clusterHostAndPortList);
    }

    private HostAndPortUtil() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static List<HostAndPort> parseHosts(String envHosts, List<HostAndPort> existingHostsAndPorts) {
        String[] hostDefs;
        if (envHosts != null && envHosts.length() > 0 && (hostDefs = envHosts.split(",")) != null && 2 <= hostDefs.length) {
            ArrayList<HostAndPort> envHostsAndPorts = new ArrayList<HostAndPort>(hostDefs.length);
            String[] stringArray = hostDefs;
            int n = hostDefs.length;
            int n2 = 0;
            while (n2 < n) {
                String hostDef = stringArray[n2];
                String[] hostAndPort = hostDef.split(":");
                if (hostAndPort != null && 2 == hostAndPort.length) {
                    String host = hostAndPort[0];
                    int port = 6379;
                    try {
                        port = Integer.parseInt(hostAndPort[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    envHostsAndPorts.add(new HostAndPort(host, port));
                }
                ++n2;
            }
            return envHostsAndPorts;
        }
        return existingHostsAndPorts;
    }

    public static List<HostAndPort> getRedisServers() {
        return redisHostAndPortList;
    }

    public static List<HostAndPort> getSentinelServers() {
        return sentinelHostAndPortList;
    }

    public static List<HostAndPort> getClusterServers() {
        return clusterHostAndPortList;
    }
}

