/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class ConnectionTest
extends Assert {
    private Connection client;

    @Before
    public void setUp() throws Exception {
        this.client = new Connection();
    }

    @After
    public void tearDown() throws Exception {
        this.client.disconnect();
    }

    @Test(expected=JedisConnectionException.class)
    public void checkUnkownHost() {
        this.client.setHost("someunknownhost");
        this.client.connect();
    }

    @Test(expected=JedisConnectionException.class)
    public void checkWrongPort() {
        this.client.setHost("localhost");
        this.client.setPort(55665);
        this.client.connect();
    }

    @Test
    public void connectIfNotConnectedWhenSettingTimeoutInfinite() {
        this.client.setHost("localhost");
        this.client.setPort(6379);
        this.client.setTimeoutInfinite();
    }

    @Test
    public void checkCloseable() {
        this.client.setHost("localhost");
        this.client.setPort(6379);
        this.client.connect();
        this.client.close();
    }

    @Test
    public void getErrorAfterConnectionReset() throws Exception {
        class TestConnection
        extends Connection {
            public TestConnection() {
                super("localhost", 6379);
            }

            @Override
            protected Connection sendCommand(Protocol.Command cmd, byte[] ... args) {
                return super.sendCommand(cmd, args);
            }
        }
        TestConnection conn = new TestConnection();
        try {
            conn.sendCommand(Protocol.Command.HMSET, new byte[0x100001][0]);
            ConnectionTest.fail((String)"Should throw exception");
        }
        catch (JedisConnectionException jce) {
            ConnectionTest.assertEquals((Object)"ERR Protocol error: invalid multibulk length", (Object)jce.getMessage());
        }
    }
}

