/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.Connection;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class ConnectionCloseTest
extends Assert {
    private Connection client;

    @Before
    public void setUp() throws Exception {
        this.client = new Connection();
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test(expected=JedisConnectionException.class)
    public void checkUnkownHost() {
        this.client.setHost("someunknownhost");
        this.client.connect();
    }

    @Test(expected=JedisConnectionException.class)
    public void checkWrongPort() {
        this.client.setHost("localhost");
        this.client.setPort(55665);
        this.client.connect();
    }

    @Test
    public void connectIfNotConnectedWhenSettingTimeoutInfinite() {
        this.client.setHost("localhost");
        this.client.setPort(6379);
        this.client.setTimeoutInfinite();
    }
}

