/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Serializable;

public class HostAndPort
implements Serializable {
    private static final long serialVersionUID = -519876229978427751L;
    public static final String LOCALHOST_STR = "localhost";
    private String host;
    private int port;

    public HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HostAndPort) {
            HostAndPort hp = (HostAndPort)obj;
            String thisHost = this.convertHost(this.host);
            String hpHost = this.convertHost(hp.host);
            return this.port == hp.port && thisHost.equals(hpHost);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.convertHost(this.host).hashCode() + this.port;
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    private String convertHost(String host) {
        if (host.equals("127.0.0.1")) {
            return LOCALHOST_STR;
        }
        if (host.equals("::1")) {
            return LOCALHOST_STR;
        }
        return host;
    }
}

