/*
 * Decompiled with CFR 0.152.
 */
package com.MFN.redisk;

import com.MFN.redisk.RegisterSkript;
import com.MFN.redisk.Subscriber;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RediSK
extends JavaPlugin {
    public static Plugin plugin;
    public static Subscriber subscriber;
    public static JedisPool pool;
    public static String ip;
    public static String password;
    public static int port;
    public static String[] channels;
    public static boolean connected;

    static {
        connected = false;
    }

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        ip = this.getConfig().getString("redis-ip");
        port = this.getConfig().getInt("redis-port");
        String password = this.getConfig().getString("redis-password");
        List chnls = this.getConfig().getList("channels");
        this.getLogger().info("Listening for channels:");
        channels = new String[chnls.size()];
        int counter = 0;
        Iterator iterator = chnls.iterator();
        while (iterator.hasNext()) {
            String s;
            RediSK.channels[counter] = s = (String)iterator.next();
            this.getLogger().info(String.valueOf(Integer.toString(++counter)) + ": " + s);
        }
        pool = password == null || password.equals("") ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), ip, port, 0) : new JedisPool(new JedisPoolConfig(), ip, port, 0, password);
        new BukkitRunnable(){

            public void run() {
                subscriber = new Subscriber();
                Jedis jedis = pool.getResource();
                try {
                    connected = true;
                    jedis.subscribe(subscriber, channels);
                }
                catch (Exception e) {
                    RediSK.this.getLogger().severe("Can't connect to Redis! Are you sure it's running and your config is correct?");
                }
                jedis.close();
                connected = false;
            }
        }.runTaskAsynchronously((Plugin)this);
        new RegisterSkript(this);
    }

    public void onDisable() {
        if (connected) {
            subscriber.unsubscribe();
            pool.destroy();
        }
    }

    public static void sendMessage(final String channel, final String msg) {
        if (!connected) {
            return;
        }
        final Jedis jedis = pool.getResource();
        new BukkitRunnable(){

            public void run() {
                if (!connected) {
                    return;
                }
                try {
                    jedis.publish(channel, msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                jedis.close();
            }
        }.runTaskAsynchronously(plugin);
    }
}

