/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.reflection;

import ch.njol.util.Pair;
import com.mirre.random.utils.reflection.core.ArgumentFunction;
import java.lang.reflect.Field;
import java.util.Optional;

public class ReflectedField<T>
extends ArgumentFunction<ReflectedField<T>, Object, T> {
    private Field field;
    private String fieldName;
    private boolean isSetter = false;

    public ReflectedField(String fieldName) {
        this.fieldName = fieldName;
    }

    public ReflectedField(Class<?> source, String fieldName) {
        this.fieldName = fieldName;
        this.getField(source);
    }

    public ReflectedField(Field field) {
        this.field = field;
    }

    @Override
    public T apply(Object target) {
        Pair pair;
        if (target instanceof Pair) {
            pair = (Pair)target;
        } else {
            pair = new Pair(target, (Object)this.arguments());
            this.discardArguments();
        }
        if (this.field == null) {
            this.getField(pair.getKey() instanceof Class ? (Class<?>)pair.getKey() : pair.getKey().getClass());
        }
        if (!this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        try {
            if (!this.isSetter) {
                return (T)this.field.get(pair.getKey());
            }
            this.field.set(pair.getKey(), this.field.getType().isArray() ? pair.getValue() : (pair.getValue() != null ? ((Object[])pair.getValue())[0] : null));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void set(Object target, Object ... arguments) {
        this.args(arguments);
        this.asSetter(true);
        this.apply(target);
        this.asSetter(false);
    }

    public Optional<Field> getField(Class<?> c) {
        if (this.field == null) {
            try {
                this.field = c.getDeclaredField(this.fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return Optional.ofNullable(this.field);
    }

    public ReflectedField<T> asSetter(boolean b) {
        this.isSetter = b;
        return this;
    }

    public boolean isSetter() {
        return this.isSetter;
    }
}

