/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.config;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Option;
import ch.njol.skript.util.FileUtils;
import com.mirre.random.RandomSK;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;

public class RandomSKConfig {
    static Config mainConfig;
    static final Option<String> version;

    static {
        version = new Option("version", (Object)"2.7").optional(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean load() {
        try {
            Config mc;
            InputStream in;
            File configFile = new File(RandomSK.getInstance().getDataFolder(), "config.sk");
            if (!configFile.exists()) {
                ZipFile f = null;
                try {
                    f = new ZipFile(RandomSK.file());
                    in = f.getInputStream(f.getEntry("config.sk"));
                    try {
                        FileUtils.save((InputStream)in, (File)configFile);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!configFile.canRead()) {
                Bukkit.getLogger().info("[RandomSK] Cannot read config file.");
                return false;
            }
            try {
                mc = new Config(configFile, false, false, ":");
            }
            catch (IOException e) {
                Bukkit.getLogger().info("Could not load the main config: " + e.getLocalizedMessage());
                return false;
            }
            mainConfig = mc;
            if (!"2.7".equals(mc.get(new String[]{RandomSKConfig.version.key}))) {
                try {
                    in = RandomSK.getInstance().getResource("config.sk");
                    if (in == null) {
                        Skript.error((String)"Your config is outdated, but Skript couldn't find the newest config in its jar. Please download Skript again from dev.bukkit.org.");
                        return false;
                    }
                    Config newConfig = new Config(in, "Skript.jar/config.sk", false, false, ":");
                    in.close();
                    File bu = FileUtils.backup((File)configFile);
                    newConfig.getMainNode().set(RandomSKConfig.version.key, "2.7");
                    mc = mainConfig = newConfig;
                    mc.save(configFile);
                    Skript.info((String)("Your configuration has been updated to the latest version. A backup of your old config file has been created as " + bu.getName()));
                }
                catch (IOException e) {
                    Skript.error((String)("Could not load the new config from the jar file: " + e.getLocalizedMessage()));
                }
            }
            mc.load(RandomSKConfig.class);
            return true;
        }
        catch (RuntimeException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"An error occurred while loading the config"});
            return false;
        }
    }
}

