/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.config;

import org.bukkit.plugin.java.JavaPlugin;

public class ConfigHandler {
    private JavaPlugin plugin;
    private final double version = 1.1;
    private boolean suppressWarningWarnings;
    private boolean debug;
    private boolean steerEventEnabled;
    private int delaySteerEvent;

    public ConfigHandler(JavaPlugin plugin) {
        this.plugin = plugin;
        this.init();
    }

    public void init() {
        this.plugin.saveDefaultConfig();
        this.suppressWarningWarnings = this.plugin.getConfig().getBoolean("suppress-feature-is-warning");
        this.debug = this.plugin.getConfig().getBoolean("debug");
        this.steerEventEnabled = this.plugin.getConfig().contains("steer-vehicle-event") ? this.plugin.getConfig().getBoolean("steer-vehicle-event") : true;
        int n = this.delaySteerEvent = this.plugin.getConfig().contains("delay-steer-vehicle-event") ? this.plugin.getConfig().getInt("delay-steer-vehicle-event") : 10;
        if (this.plugin.getConfig().getDouble("config-version") != 1.1) {
            this.plugin.saveResource("config.yml", true);
            this.plugin.getConfig().set("suppress-feature-is-warning", (Object)this.suppressWarningWarnings);
            this.plugin.getConfig().set("debug-register", (Object)this.debug);
            this.plugin.getConfig().set("config-version", (Object)1.1);
            this.plugin.getConfig().set("steer-vehicle-event", (Object)this.steerEventEnabled);
            this.plugin.getConfig().set("delay-steer-vehicle-event", (Object)this.delaySteerEvent);
            this.plugin.saveConfig();
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean shouldSuppressWarningWarnings() {
        return this.suppressWarningWarnings;
    }

    public boolean isSteerEventEnabled() {
        return this.steerEventEnabled;
    }

    public int getDelaySteerEvent() {
        return this.delaySteerEvent;
    }
}

