/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.lang.annonations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Warning {
    public Reason reason();

    public String data() default "";

    public static enum Reason {
        INCOMPLETE("This feature is incomplete. Use at your own risk. Disable these messages in RandomSK config."),
        BUGGY("This feature is buggy. Use at your own risk. Disable these messages in RandomSK config."),
        DEPRECATED("This feature is deprecated. Use {data} instead. Disable these messages in RandomSK config.");

        private final String reason;

        private Reason(String reason) {
            this.reason = reason;
        }

        public String getReason(String data) {
            return this.reason.contains("{data}") ? this.reason.replace("{data}", data) : this.reason;
        }
    }
}

