/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.features.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.util.Timespan;
import com.mirre.random.lang.abstracts.Changer;
import com.mirre.random.lang.annonations.ChangeModes;
import com.mirre.random.lang.annonations.Pattern;
import com.mirre.random.lang.expressions.RandomPropertyExpression;
import com.mirre.random.utils.enums.BlockFeature;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Pattern(patterns={"{S}brew[ing] time of %block%", "{S}burn[ing] time of %block%", "{S}cook[ing] time of %block%", "{S}[mob] spawn delay of %block%"})
@ChangeModes(changeModes={Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE})
public class ExprBlockFeatures
extends RandomPropertyExpression<Block, Timespan>
implements Changer {
    public Timespan[] get(Block from) {
        BlockFeature bf = BlockFeature.getBlockFeature(this.patternMark);
        Number n = null;
        try {
            n = bf.get(from);
        }
        catch (Exception ex) {
            return null;
        }
        return new Timespan[]{Timespan.fromTicks((int)n.intValue())};
    }

    @Override
    public void changer(Event event, Object[] delta, Changer.ChangeMode mode) {
        Block b = this.expressions.getSingle(event, Block.class, 0);
        Timespan time = (Timespan)delta[0];
        BlockFeature bf = BlockFeature.getBlockFeature(this.parseMark);
        Number n = bf.get(b);
        if (n == null && mode != Changer.ChangeMode.SET) {
            return;
        }
        Integer dur = null;
        switch (mode) {
            case ADD: {
                dur = n.intValue() + time.getTicks();
                break;
            }
            case REMOVE: {
                dur = n.intValue() - time.getTicks();
                break;
            }
            case SET: {
                dur = time.getTicks();
                break;
            }
        }
        bf.set(b, dur);
    }
}

