/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.events;

import com.mirre.random.utils.reflection.ReflectedField;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class NamedSoundEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Object packet;
    private Player player;
    private String sound;
    private Location loc;
    private float volume;
    private int pitch;
    private boolean cancelled = false;
    private static final ReflectedField<String> soundName = new ReflectedField("a");
    private static final ReflectedField<Integer> xField = new ReflectedField("b");
    private static final ReflectedField<Integer> yField = new ReflectedField("c");
    private static final ReflectedField<Integer> zField = new ReflectedField("d");
    private static final ReflectedField<Float> volumeField = new ReflectedField("e");
    private static final ReflectedField<Integer> pitchField = new ReflectedField("f");

    private NamedSoundEvent(Player player, Object packet) {
        this.player = player;
        this.packet = packet;
        this.sound = soundName.apply(packet);
        this.volume = volumeField.apply(packet).floatValue();
        this.pitch = pitchField.apply(packet);
        int x = xField.apply(packet) / 8;
        int y = yField.apply(packet) / 8;
        int z = zField.apply(packet) / 8;
        this.loc = new Location(player.getWorld(), (double)x, (double)y, (double)z);
    }

    public static NamedSoundEvent callEvent(Player player, Object packet) {
        NamedSoundEvent event = new NamedSoundEvent(player, packet);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLoc() {
        return this.loc;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        if (this.validSoundName(sound)) {
            this.sound = sound;
            soundName.set(this.packet, sound);
        }
    }

    private boolean validSoundName(String sound) {
        return true;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
        volumeField.set(this.packet, Float.valueOf(volume));
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = pitch;
        pitchField.set(this.packet, pitch);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean b) {
        this.cancelled = b;
    }

    public Object getPacket() {
        return this.packet;
    }
}

