/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.lang.data;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import com.mirre.random.RandomSK;
import com.mirre.random.lang.abstracts.AbstractFeature;
import com.mirre.random.lang.annonations.ChangeModes;
import com.mirre.random.lang.annonations.ExpressionsType;
import com.mirre.random.lang.expressions.RandomPropertyExpression;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class ExpressionFeature
extends AbstractFeature<Expression> {
    private Changer.ChangeMode[] changeModes = null;
    private Class<?>[] acceptModes = null;
    private boolean isProperty;
    private Class<?> returnType = null;
    private ExpressionType type = null;

    public ExpressionFeature(Class<? extends Expression> feature) {
        super(feature);
        this.isProperty = RandomPropertyExpression.class.isAssignableFrom(feature);
        if (this.isProperty) {
            this.type = ExpressionType.PROPERTY;
        }
    }

    public ExpressionType getType() {
        if (this.clazz.isAnnotationPresent(ExpressionsType.class)) {
            ExpressionsType p = this.clazz.getDeclaredAnnotation(ExpressionsType.class);
            return p.type();
        }
        return this.type == null ? ExpressionType.SIMPLE : this.type;
    }

    public Changer.ChangeMode[] getChangeModes() {
        if (this.changeModes == null && this.clazz.isAnnotationPresent(ChangeModes.class)) {
            ChangeModes p = this.clazz.getDeclaredAnnotation(ChangeModes.class);
            this.changeModes = p.changeModes();
        }
        return this.changeModes;
    }

    public Class<?>[] getAcceptModes() {
        if (this.acceptModes == null && this.clazz.isAnnotationPresent(ChangeModes.class)) {
            Class<?>[] classArray;
            ChangeModes p = this.clazz.getDeclaredAnnotation(ChangeModes.class);
            if (p.acceptModes().length == 1 && p.acceptModes()[0] == Class.class) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = this.getReturnType();
            } else {
                classArray = p.acceptModes();
            }
            this.acceptModes = classArray;
        }
        return this.acceptModes;
    }

    public Type[] getTypeArgument() {
        return ((ParameterizedType)this.clazz.getGenericSuperclass()).getActualTypeArguments();
    }

    public Class<?> getReturnType() {
        if (this.returnType == null) {
            Type[] types = ((ParameterizedType)this.clazz.getGenericSuperclass()).getActualTypeArguments();
            this.returnType = this.isProperty ? (Class)types[1] : (Class)types[0];
        }
        return this.returnType;
    }

    @Override
    public void register() {
        if (this.isSupported()) {
            if (RandomSK.DEBUG) {
                System.out.println("Registering: " + this.clazz.getSimpleName() + " Patterns: " + Arrays.toString(this.getExtractedPatterns()));
            }
            Skript.registerExpression((Class)this.clazz, this.getReturnType(), (ExpressionType)this.getType(), (String[])this.getExtractedPatterns());
        }
    }
}

