/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.lang.abstracts;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import com.mirre.random.RandomSK;
import com.mirre.random.lang.abstracts.Feature;
import com.mirre.random.lang.annonations.Events;
import com.mirre.random.lang.annonations.Pattern;
import com.mirre.random.lang.annonations.Supported;
import com.mirre.random.lang.annonations.Warning;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.bukkit.event.Event;

public abstract class AbstractFeature<T>
implements Feature<T> {
    private String[] rawPatterns = null;
    private String[] extractedPatterns = null;
    private Class<? extends Event>[] forEvents = null;
    protected Class<? extends T> clazz;
    private static java.util.regex.Pattern MATCH_VARIABLE = java.util.regex.Pattern.compile("\\{([^\\}]+)\\}");

    public AbstractFeature(Class<? extends T> feature) {
        this.clazz = feature;
    }

    @Override
    public void checkWarning() {
        if (RandomSK.config().shouldSuppressWarningWarnings()) {
            return;
        }
        if (this.clazz.isAnnotationPresent(Warning.class)) {
            Warning w = this.clazz.getDeclaredAnnotation(Warning.class);
            Skript.warning((String)w.reason().getReason(w.data()));
        }
    }

    @Override
    public String[] getRawPatterns() {
        if (this.rawPatterns == null && this.clazz.isAnnotationPresent(Pattern.class)) {
            Pattern p = this.clazz.getDeclaredAnnotation(Pattern.class);
            this.rawPatterns = p.patterns();
        }
        return this.rawPatterns;
    }

    public String[] getExtractedPatterns() {
        if (this.extractedPatterns == null) {
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = this.getRawPatterns();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                StringBuffer output = new StringBuffer();
                Matcher matcher = MATCH_VARIABLE.matcher(pattern);
                while (matcher.find()) {
                    matcher.appendReplacement(output, Matcher.quoteReplacement(""));
                }
                matcher.appendTail(output);
                String s = output.toString();
                while (s.startsWith(" ")) {
                    s = s.replaceFirst(" ", "");
                }
                list.add(s);
                ++n2;
            }
            this.extractedPatterns = list.toArray(new String[list.size()]);
        }
        return this.extractedPatterns;
    }

    @Override
    public Class<? extends Event>[] forEvents() {
        if (this.forEvents == null && this.clazz.isAnnotationPresent(Events.class)) {
            Events e = this.clazz.getDeclaredAnnotation(Events.class);
            this.forEvents = e.forEvents();
        }
        return this.forEvents;
    }

    @Override
    public boolean isSupported() {
        if (this.clazz.isAnnotationPresent(Supported.class)) {
            Supported s = this.clazz.getDeclaredAnnotation(Supported.class);
            return RandomSK.NMS_VERSION >= s.from() && (RandomSK.NMS_VERSION <= s.to() || s.to() == 0);
        }
        return true;
    }

    @Override
    public boolean eventIsSupported() {
        Class[] events = this.forEvents();
        if (events == null) {
            return true;
        }
        if (!ScriptLoader.isCurrentEvent((Class[])events)) {
            Skript.error((String)("Cannot use " + this.clazz.getSimpleName() + " feature outside of the " + ScriptLoader.getCurrentEventName() + " event."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }
}

