/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.features.expressions;

import ch.njol.skript.classes.Changer;
import com.mirre.random.RandomSK;
import com.mirre.random.lang.abstracts.Changer;
import com.mirre.random.lang.annonations.ChangeModes;
import com.mirre.random.lang.annonations.Pattern;
import com.mirre.random.lang.expressions.RandomPropertyExpression;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Pattern(patterns={"{S}[the] (0\u00a6yaw|1\u00a6pitch) of %location%", "{S}%location%'s (0\u00a6yaw|1\u00a6pitch)"})
@ChangeModes(changeModes={Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE})
public class ExprPitchYaw
extends RandomPropertyExpression<Location, Number>
implements Changer {
    @Override
    public void changer(Event event, Object[] delta, Changer.ChangeMode mode) {
        Location l = this.expressions.getSingle(event, Location.class, 0);
        Number n = (Number)delta[0];
        switch (mode) {
            case SET: {
                if (this.parseMark == 0) {
                    l.setYaw(this.convertToPositive(Float.valueOf(n.floatValue())));
                    break;
                }
                l.setPitch(n.floatValue());
                break;
            }
            case ADD: {
                if (this.parseMark == 0) {
                    l.setYaw(this.convertToPositive(Float.valueOf(l.getYaw())) + n.floatValue());
                    break;
                }
                l.setPitch(l.getPitch() + n.floatValue());
                break;
            }
            case REMOVE: {
                if (this.parseMark == 0) {
                    l.setYaw(this.convertToPositive(Float.valueOf(l.getYaw())) - n.floatValue());
                    break;
                }
                l.setPitch(l.getPitch() - n.floatValue());
                break;
            }
        }
    }

    public Number[] get(Location from) {
        return new Number[]{Float.valueOf(this.parseMark == 0 ? this.convertToPositive(Float.valueOf(from.getYaw())) : from.getPitch())};
    }

    @Override
    public boolean isSupported() {
        return !RandomSK.isUsingSkriptMirre();
    }

    public float convertToPositive(Number n) {
        if (Math.signum(n.floatValue()) == -1.0f) {
            return 360.0f + n.floatValue();
        }
        return n.floatValue();
    }
}

