/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.features.expressions;

import ch.njol.skript.classes.Changer;
import com.mirre.random.lang.abstracts.Changer;
import com.mirre.random.lang.annonations.ChangeModes;
import com.mirre.random.lang.annonations.Pattern;
import com.mirre.random.lang.expressions.RandomPropertyExpression;
import org.bukkit.World;
import org.bukkit.event.Event;

@Pattern(patterns={"{S}[the] (1\u00a6monster|2\u00a6animal|3\u00a6water[(-| )]animals|4\u00a6ambient) spawn limit[s] of %world%", "{S}%world%'s (1\u00a6monster|2\u00a6animal|3\u00a6water[(-| )]animals|4\u00a6ambient) spawn limit[s]"})
@ChangeModes(changeModes={Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE})
public class ExprBukkitConfig
extends RandomPropertyExpression<World, Number>
implements Changer {
    public Number[] get(World from) {
        switch (this.parseMark) {
            case 1: {
                return new Number[]{from.getMonsterSpawnLimit()};
            }
            case 2: {
                return new Number[]{from.getAnimalSpawnLimit()};
            }
            case 3: {
                return new Number[]{from.getWaterAnimalSpawnLimit()};
            }
            case 4: {
                return new Number[]{from.getAmbientSpawnLimit()};
            }
        }
        return null;
    }

    @Override
    public void changer(Event event, Object[] delta, Changer.ChangeMode mode) {
        World from = this.expressions.getSingle(event, World.class, 0);
        Number n = (Number)delta[0];
        switch (mode) {
            case ADD: {
                n = this.get(from)[0].intValue() + n.intValue();
                break;
            }
            case REMOVE: {
                n = this.get(from)[0].intValue() - n.intValue();
                break;
            }
        }
        switch (this.parseMark) {
            case 1: {
                from.setMonsterSpawnLimit(n.intValue());
                break;
            }
            case 2: {
                from.setAnimalSpawnLimit(n.intValue());
                break;
            }
            case 3: {
                from.setWaterAnimalSpawnLimit(n.intValue());
                break;
            }
            case 4: {
                from.setMonsterSpawnLimit(n.intValue());
            }
        }
    }
}

