/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.lang.data.lists;

import ch.njol.skript.lang.Expression;
import com.mirre.random.RandomSK;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class ExpressionList {
    private Expression<?>[] expressions;
    private Map<String, Integer> expressionNames = new HashMap<String, Integer>();
    private static Pattern MATCH_EXPRESSION = Pattern.compile("\\%([^\\%]+)\\%");

    public ExpressionList(Expression<?>[] expressions, String pattern) {
        Matcher matcher = MATCH_EXPRESSION.matcher(pattern);
        int i = 0;
        while (matcher.find()) {
            String expression = matcher.group(1);
            if (expression.startsWith("-")) {
                expression = expression.substring(1, expression.length());
            }
            if (expression.contains("/")) {
                expression = "object";
            }
            if (expression.endsWith("s")) {
                expression = expression.substring(0, expression.length() - 1);
            }
            if (this.expressionNames.containsKey(expression = String.valueOf(expression) + "0")) {
                while (this.expressionNames.containsKey(expression)) {
                    String lastChar = "" + expression.charAt(expression.length() - 1);
                    if (!lastChar.matches("[0-9]")) continue;
                    int integer = Integer.parseInt(lastChar);
                    expression = expression.replace(lastChar, "");
                    expression = String.valueOf(expression) + (integer + 1);
                }
            }
            this.expressionNames.put(expression, i);
            ++i;
        }
        this.expressions = expressions;
    }

    public int size() {
        return this.expressionNames.size();
    }

    public boolean catchAnyNull(Event event) {
        Expression<?>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<?> e = expressionArray[n2];
            if (e != null && e.isSingle()) {
                if (e.getSingle(event) == null) {
                    if (RandomSK.DEBUG) {
                        System.out.println("[RandomSK] One or more expressions/variables are null.");
                    }
                    return true;
                }
            } else if (e != null && (e.getAll(event).length == 0 || e.getAll(event) == null)) {
                if (RandomSK.DEBUG) {
                    System.out.println("[RandomSK] One or more expressions/variables are null.");
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public <T> T getSingle(Event event, Class<T> clazz, int index) {
        if (this.expressionNames.containsKey(String.valueOf(clazz.getSimpleName().toLowerCase()) + index)) {
            int i = this.expressionNames.get(String.valueOf(clazz.getSimpleName().toLowerCase()) + index);
            return (T)this.expressions[i].getSingle(event);
        }
        return null;
    }

    public Expression<?> get(String key) {
        if (this.expressionNames.containsKey(key)) {
            int i = this.expressionNames.get(key);
            return this.expressions[i];
        }
        return null;
    }

    public <T> T[] getAll(Event event, Class<T> clazz, int index) {
        if (this.expressionNames.containsKey(String.valueOf(clazz.getSimpleName().toLowerCase()) + index)) {
            int i = this.expressionNames.get(String.valueOf(clazz.getSimpleName().toLowerCase()) + index);
            return this.expressions[i].getAll(event);
        }
        return null;
    }

    public Map<String, Integer> getMap() {
        return this.expressionNames;
    }

    public Expression<?>[] getExpressions() {
        return this.expressions;
    }
}

