/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.mirre.random.lang.abstracts.Changer;
import com.mirre.random.lang.abstracts.Register;
import com.mirre.random.lang.data.ExpressionFeature;
import com.mirre.random.lang.data.lists.ExpressionList;
import com.mirre.random.lang.data.results.ExpressionResult;
import com.mirre.random.utils.CommonUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public abstract class RandomExpression<T>
extends SimpleExpression<T>
implements Register {
    private ExpressionFeature feature = new ExpressionFeature((Class<? extends Expression>)this.getClass());
    private ExpressionResult result = null;
    protected ExpressionList expressions = null;
    protected int patternMark;
    protected int parseMark;

    @Override
    public void register() {
        if (this.isSupported()) {
            this.feature.register();
        }
    }

    public Class<? extends T> getReturnType() {
        return this.feature.getReturnType();
    }

    public boolean isSingle() {
        return this.result.isSingle();
    }

    public boolean init(Expression<?>[] expressions, int patternMark, Kleenean kl, SkriptParser.ParseResult pr) {
        if (this.feature.isIncomplete()) {
            Skript.warning((String)"This expression either has some bugs in it or is incomplete. Use at your own risk. Disable these messages in RandomSK config.");
        }
        if (!this.feature.eventIsSupported()) {
            return false;
        }
        this.result = new ExpressionResult(this.feature.getRawPatterns()[patternMark]);
        this.expressions = new ExpressionList(expressions, this.feature.getExtractedPatterns()[0]);
        this.patternMark = patternMark;
        this.parseMark = pr.mark;
        return true;
    }

    public String toString(Event event, boolean b) {
        return this.getClass().getSimpleName();
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.expressions.catchAnyNull(event) || CommonUtils.nullCheck(delta)) {
            return;
        }
        if (this instanceof Changer) {
            ((Changer)((Object)this)).changer(event, delta, mode);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Changer.ChangeMode[] changeModeArray = this.feature.getChangeModes();
        int n = changeModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Changer.ChangeMode m = changeModeArray[n2];
            if (mode == m) {
                return (Class[])CollectionUtils.array((Object[])this.feature.getAcceptModes());
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    protected T[] get(Event event) {
        if (this.expressions.catchAnyNull(event)) {
            return null;
        }
        return this.obtain(event);
    }

    public abstract T[] obtain(Event var1);
}

