/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mirre.random.lang.abstracts.Register;
import com.mirre.random.lang.data.EffectFeature;
import com.mirre.random.lang.data.lists.ExpressionList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public abstract class RandomEffect
extends Effect
implements Register {
    private EffectFeature feature = new EffectFeature((Class<? extends Effect>)this.getClass());
    protected ExpressionList expressions = null;
    protected int patternMark;
    protected int parseMark;

    @Override
    public void register() {
        if (this.isSupported()) {
            this.feature.register();
        }
    }

    public boolean init(Expression<?>[] expressions, int patternMark, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.feature.isIncomplete()) {
            Skript.warning((String)"This effect either has some bugs in it or is incomplete. Use at your own risk. Disable these messages in RandomSK config.");
        }
        if (!this.feature.eventIsSupported()) {
            return false;
        }
        this.expressions = new ExpressionList(expressions, this.feature.getExtractedPatterns()[patternMark]);
        this.patternMark = patternMark;
        this.parseMark = parseResult.mark;
        return true;
    }

    public String toString(@Nullable Event event, boolean flag) {
        return this.getClass().getSimpleName();
    }

    protected void execute(Event event) {
        if (this.expressions.catchAnyNull(event)) {
            return;
        }
        this.perform(event);
    }

    public abstract void perform(Event var1);
}

