/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.features.items;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.util.Timespan;
import com.mirre.random.lang.abstracts.Changer;
import com.mirre.random.lang.annonations.ChangeModes;
import com.mirre.random.lang.annonations.Pattern;
import com.mirre.random.lang.expressions.RandomPropertyExpression;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;

@Pattern(patterns={"{S}[the] pick up delay of %entity%", "{S}%entity%'s pick up delay"})
@ChangeModes(changeModes={Changer.ChangeMode.SET})
public class ExprPickUpDelay
extends RandomPropertyExpression<Entity, Timespan>
implements Changer {
    public Timespan[] get(Entity from) {
        if (from.getType() != EntityType.DROPPED_ITEM) {
            return null;
        }
        Item i = (Item)from;
        if (i.getPickupDelay() <= 0) {
            return null;
        }
        return new Timespan[]{Timespan.fromTicks((int)i.getPickupDelay())};
    }

    @Override
    public void changer(Event event, Object[] delta, Changer.ChangeMode mode) {
        Timespan ts = (Timespan)delta[0];
        Entity ent = this.expressions.getSingle(event, Entity.class, 0);
        if (ent.getType() != EntityType.DROPPED_ITEM) {
            return;
        }
        Item i = (Item)ent;
        i.setPickupDelay(ts.getTicks());
    }
}

