/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.features.fishing;

import ch.njol.skript.classes.Changer;
import com.mirre.random.lang.RandomExpression;
import com.mirre.random.lang.abstracts.Changer;
import com.mirre.random.lang.annonations.ChangeModes;
import com.mirre.random.lang.annonations.Events;
import com.mirre.random.lang.annonations.Pattern;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;

@Pattern(patterns={"{S}bite chance"})
@Events(forEvents={PlayerFishEvent.class})
@ChangeModes(changeModes={Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE})
public class ExprBiteChance
extends RandomExpression<Number>
implements Changer {
    public Number[] obtain(Event event) {
        Double d = ((PlayerFishEvent)event).getHook().getBiteChance();
        return new Number[]{d};
    }

    @Override
    public void changer(Event event, Object[] delta, Changer.ChangeMode mode) {
        Number d = (Number)delta[0];
        PlayerFishEvent fishEvent = (PlayerFishEvent)event;
        if (d != null) {
            switch (mode) {
                case ADD: {
                    d = fishEvent.getHook().getBiteChance() + d.doubleValue();
                    break;
                }
                case DELETE: {
                    break;
                }
                case REMOVE: {
                    d = fishEvent.getHook().getBiteChance() - d.doubleValue();
                    break;
                }
            }
            fishEvent.getHook().setBiteChance(d.doubleValue());
        }
    }
}

