/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.reflection;

import com.mirre.random.utils.reflection.core.ArgumentFunction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javafx.util.Pair;

public class ReflectedMethod<T>
extends ArgumentFunction<ReflectedMethod<T>, Object, T> {
    private Method method;
    private String methodName;
    private Class<?>[] parameters = new Class[0];
    private boolean objectAsArg = false;

    public ReflectedMethod(String methodName) {
        this.methodName = methodName;
    }

    public ReflectedMethod(Method method) {
        this.method = method;
    }

    public ReflectedMethod(String methodName, Class<?> ... parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public ReflectedMethod(Class<?> source, String methodName) {
        this.methodName = methodName;
        this.getMethod(source);
    }

    public ReflectedMethod(Class<?> source, String methodName, Class<?> ... parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
        this.getMethod(source);
    }

    @Override
    public T apply(Object target) {
        Pair pair;
        if (target instanceof Pair) {
            pair = (Pair)target;
        } else {
            pair = new Pair(target, (Object)this.arguments());
            this.discardArguments();
        }
        if (this.method == null) {
            this.getMethod(pair.getKey() instanceof Class ? (Class<?>)pair.getKey() : pair.getKey().getClass());
        }
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        try {
            return (T)(this.objectAsArg ? this.method.invoke(null, pair.getKey()) : this.method.invoke(pair.getKey(), (Object[])pair.getValue()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public T apply(Object target, Object ... arguments) {
        this.args(arguments);
        return this.apply(target);
    }

    public Optional<Method> getMethod(Class<?> c) {
        if (this.method == null) {
            try {
                this.method = c.getDeclaredMethod(this.methodName, this.parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Optional.ofNullable(this.method);
    }

    public ReflectedMethod<T> useObjectAsArg() {
        if (this.parameters.length == 1) {
            this.objectAsArg = true;
        }
        return this;
    }
}

