/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.reflection;

import com.mirre.random.utils.reflection.ReflectedField;
import com.mirre.random.utils.reflection.ReflectedObject;
import com.mirre.random.utils.reflection.core.ReflectionField;
import com.mirre.random.utils.reflection.core.ReflectionFunction;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javafx.util.Pair;

public class Reflect
implements InvocationHandler {
    private Object internalObject;
    private Class<?> interfaze;

    public static <T> T create(Class<T> classInterface, Object o) {
        if (o == null || classInterface == null) {
            return null;
        }
        return (T)Proxy.newProxyInstance(classInterface.getClassLoader(), new Class[]{classInterface}, (InvocationHandler)new Reflect(o, classInterface));
    }

    public static Object getInternalObject(Object object) {
        return Proxy.getInvocationHandler(object) instanceof Reflect ? ((Reflect)Proxy.getInvocationHandler((Object)object)).internalObject : null;
    }

    private Reflect(Object internalObject, Class<?> interfaze) {
        this.internalObject = internalObject;
        this.interfaze = interfaze;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        try {
            if (method.isAnnotationPresent(ReflectionField.class)) {
                String fieldName = method.getAnnotation(ReflectionField.class).field();
                ReflectedField f = new ReflectedField(fieldName);
                Object functional = new ReflectedObject(this.interfaze).end(f);
                if (functional instanceof ReflectionFunction) {
                    ReflectionFunction function = (ReflectionFunction)functional;
                    result = args == null ? function.apply(this.internalObject) : function.apply(new Pair(this.internalObject, (Object)args));
                }
            } else {
                result = method.invoke(this.internalObject, args);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

